% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr.R
\name{expr_label}
\alias{expr_label}
\alias{expr_name}
\alias{expr_text}
\title{Turn an expression to a label}
\usage{
expr_label(expr)

expr_name(expr)

expr_text(expr, width = 60L, nlines = Inf)
}
\arguments{
\item{expr}{An expression to labellise.}

\item{width}{Width of each line.}

\item{nlines}{Maximum number of lines to extract.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

\code{expr_text()} turns the expression into a single string, which
might be multi-line. \code{expr_name()} is suitable for formatting
names. It works best with symbols and scalar types, but also
accepts calls. \code{expr_label()} formats the expression nicely for use
in messages.
}
\examples{
# To labellise a function argument, first capture it with
# substitute():
fn <- function(x) expr_label(substitute(x))
fn(x:y)

# Strings are encoded
expr_label("a\nb")

# Names and expressions are quoted with ``
expr_label(quote(x))
expr_label(quote(a + b + c))

# Long expressions are collapsed
expr_label(quote(foo({
  1 + 2
  print(x)
})))
}
\keyword{internal}
