% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval-tidy.R
\docType{data}
\name{tidyeval-data}
\alias{tidyeval-data}
\alias{.data}
\alias{.env}
\title{Data pronouns for tidy evaluation}
\format{An object of class \code{rlang_fake_data_pronoun} of length .}
\usage{
.data

.env
}
\description{
These pronouns allow you to be explicit about where to find objects
when programming with data masked functions.\preformatted{m <- 10
mtcars \%>\% mutate(disp = .data$disp * .env$m)
}
\itemize{
\item \code{.data} retrieves data-variables from the data frame.
\item \code{.env} retrieves env-variables from the environment.
}

Because the lookup is explicit, there is no ambiguity between both
kinds of variables. Compare:\preformatted{disp <- 10
mtcars \%>\% mutate(disp = .data$disp * .env$disp)
mtcars \%>\% mutate(disp = disp * disp)
}

The \code{.data} object exported from rlang is also useful to import in
your package namespace to avoid a \verb{R CMD check} note when referring
to objects from the data mask.

Note that \code{.data} is only a pronoun, it is not a real data
frame. This means that you can't take its names or map a function
over the contents of \code{.data}. Similarly, \code{.env} is not an actual R
environment. For instance, it doesn't have a parent and the
subsetting operators behave differently.
}
\keyword{datasets}
