% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn.R
\name{fn_fmls}
\alias{fn_fmls}
\alias{fn_fmls_names}
\alias{fn_fmls_syms}
\alias{fn_fmls<-}
\alias{fn_fmls_names<-}
\title{Extract arguments from a function}
\usage{
fn_fmls(fn = caller_fn())

fn_fmls_names(fn = caller_fn())

fn_fmls_syms(fn = caller_fn())

fn_fmls(fn) <- value

fn_fmls_names(fn) <- value
}
\arguments{
\item{fn}{A function. It is lookep up in the calling frame if not
supplied.}

\item{value}{New formals or formals names for \code{fn}.}
}
\description{
\code{fn_fmls()} returns a named list of formal arguments.
\code{fn_fmls_names()} returns the names of the arguments.
\code{fn_fmls_syms()} returns formals as a named list of symbols. This
is especially useful for forwarding arguments in \link[=lang]{constructed calls}.
}
\details{
Unlike \code{formals()}, these helpers throw an error with primitive
functions instead of returning \code{NULL}.
}
\examples{
# Extract from current call:
fn <- function(a = 1, b = 2) fn_fmls()
fn()

# fn_fmls_syms() makes it easy to forward arguments:
call2("apply", !!! fn_fmls_syms(lapply))

# You can also change the formals:
fn_fmls(fn) <- list(A = 10, B = 20)
fn()

fn_fmls_names(fn) <- c("foo", "bar")
fn()
}
\seealso{
\code{\link[=call_args]{call_args()}} and \code{\link[=call_args_names]{call_args_names()}}
}
