% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_options.R
\name{rkeops_option_names}
\alias{rkeops_option_names}
\title{Return list of \code{rkeops} option names}
\usage{
rkeops_option_names(tag = c("compile", "runtime"))
}
\arguments{
\item{tag}{text string or vector of text string, specifying the requested
subset of \code{rkeops} options, i.e. \code{"compile"} or \code{"runtime"}. Default value
is \code{c("compile", "runtime")} and both are returned.}
}
\value{
a vector of requested \code{rkeops} options.
}
\description{
The function \code{rkeops_option_names} returns the names of the different
\code{rkeops} option (in \code{R} global options scope).
}
\details{
\code{rkeops} uses two sets of options: compile options
(see \code{\link[rkeops:compile_options]{rkeops::compile_options()}}), and runtime options
(see \code{\link[rkeops:runtime_options]{rkeops::runtime_options()}}).

These options define the behavior of \code{rkeops} when compiling or when
calling user-defined operators.

You can specify a tag (\code{"compile"} or \code{"runtime"} or both) in input, you
will get the names of the corresponding subset of \code{rkeops} options.
}
\seealso{
\code{\link[rkeops:get_rkeops_options]{rkeops::get_rkeops_options()}}, \code{\link[rkeops:set_rkeops_options]{rkeops::set_rkeops_options()}},
\code{\link[rkeops:compile_options]{rkeops::compile_options()}}, \code{\link[rkeops:runtime_options]{rkeops::runtime_options()}}
}
\author{
Ghislain Durif
}
\keyword{internal}
