% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{rjmethods}
\alias{rjmethods}
\alias{print.rj}
\alias{plot.rj}
\alias{summary.rj}
\title{Methods for the rj Class}
\usage{
\method{print}{rj}(x, ...)

\method{plot}{rj}(x, legend = TRUE, col = "maroon4", ylim = c(0, 1),
  lwd = 2, lty = c(1, 1, 1), ...)

\method{summary}{rj}(object, quantiles = c(0.025, 0.25, 0.5, 0.75, 0.975),
  ...)
}
\arguments{
\item{x, object}{An object of class \code{rj}.}

\item{...}{Further arguments to the generic method.}

\item{legend, col, ylim, lwd, lty}{Some useful graphical arguments to the generic
\code{plot} method.}

\item{quantiles}{The desired density quantiles for \code{summary} to find.}
}
\description{
An object of class \code{rj} is returned from the functions 
\code{\link{rjmcmcpost}} or \code{\link{defaultpost}}. The following methods 
can be applied to an object of this class. See Details for more information.
}
\details{
The \code{print} method prints the point estimates obtained from the 
algorithm, including the transition matrix, posterior model probabilities and
Bayes factors.

The \code{plot} method plots how the estimates of the posterior probabilities
changed as the algorithm progressed, illustrating convergence.

The \code{summary} method returns quantiles of the posterior densities for
each model (as well as likelihoods and prior densities). The point estimates
as in \code{print} are also returned. Note that this requires \code{save.all}
must be \code{TRUE} in the \code{rjmcmcpost} call.
}
