% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_passability_sequencer.R
\name{t_passability_sequencer}
\alias{t_passability_sequencer}
\title{Create the time-dependent metadata for barriers}
\usage{
t_passability_sequencer(passability_information, seq_ops)
}
\arguments{
\item{passability_information}{a data frame in wide format. Must contain an 'id_barrier' column. Each change
in passability is listed in a group of 3 columns: 'year_op', 'pass_op_u', and 'pass_op_d', listing the year the operation (op) took place, and
the related upstream and downstream passabilities. In case the passability did not change, a NA value should be used. See details.}

\item{seq_ops}{A charachter vector with the temporal sequence of operations. It should contain all the operation strings
in the 'passability_information' data frame.}
}
\value{
a dataframe in a long format that can be used as input to the tDCI function.
}
\description{
Create the time-dependent metadata for barriers
}
\details{
This function is meant to help processing data the way they can be obtained from a database, or the way they are stored in a spreadsheet.
The substring 'op' in the fields 'year_op', 'pass_op_u', and 'pass_op_d' is used to identify each operation and to relate it to the
relative passability parameters. For example, c can be used for construction, and fp for the implementation of a fish pass.
In this case, \code{passability_information} will have the fields 'year_c', 'pass_c_u', and 'pass_c_d', 'year_fp', 'pass_fp_u', and 'pass_fp_d'.
Then, the input \code{seq_ops = c("c", "fp")}, meaning that first the operation named 'c' occurred, and then the operation named 'fp' occurred.
}
\examples{
barriers_data <- data.frame("id_barrier" = c("1", "2"),
"year_c" = c(1950, 1990), "pass_c_u" = c(0.1, 0.1), "pass_c_d" = c(0.4, 0.4),
"year_fp" = c(2000, 2010), "pass_fp_u" = c(0.5, 0.5), "pass_fp_d" = c(0.8, 0.8))
seq_ops <- c("c", "fp")
t_metadata <- t_passability_sequencer(barriers_data, seq_ops)

}
