% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fnet.R
\name{plot_fnet}
\alias{plot_fnet}
\title{Plot a network diagram of frequencies and probabilities.}
\usage{
plot_fnet(prev = num$prev, sens = num$sens, mirt = NA,
  spec = num$spec, fart = NA, N = freq$N, round = TRUE,
  by = "cddc", area = "no", p_lbl = "num", show_accu = TRUE,
  w_acc = 0.5, title_lbl = txt$scen_lbl, popu_lbl = txt$popu_lbl,
  cond_true_lbl = txt$cond_true_lbl,
  cond_false_lbl = txt$cond_false_lbl, dec_pos_lbl = txt$dec_pos_lbl,
  dec_neg_lbl = txt$dec_neg_lbl, hi_lbl = txt$hi_lbl,
  mi_lbl = txt$mi_lbl, fa_lbl = txt$fa_lbl, cr_lbl = txt$cr_lbl,
  col_txt = grey(0.01, alpha = 0.99), cex_lbl = 0.85,
  col_boxes = pal, col_border = grey(0.33, alpha = 0.99), lwd = 1.5,
  box_lwd = 1.5, col_shadow = grey(0.11, alpha = 0.99),
  cex_shadow = 0)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}.}

\item{sens}{The decision's sensitivity \code{\link{sens}}.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}.}

\item{spec}{The decision's specificity value \code{\link{spec}}.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}.}

\item{N}{The number of individuals in the population.}

\item{round}{A Boolean option specifying whether computed frequencies
are rounded to integers. Default: \code{round = TRUE}.}

\item{by}{A character code specifying the perspective (or categories by which the population is split into subsets) with 3 options:
\enumerate{
\item \code{"cddc"} ... 1st by condition, 2nd by decision;
\item \code{"dccd"} ... 1st by decision, 2nd by condition;
\item \code{"cdac"} ... 1st by condition, 2nd by accuracy.
}}

\item{area}{A character code specifying the area of the boxes (or their relative sizes) with
3 options:
  \enumerate{
  \item \code{"no"} ... all boxes are shown with the same size;
  \item \code{"sq"} ... boxes are squares with area sizes scaled proportional to frequencies (default);
  \item \code{"hr"} ... boxes are horizontal rectangles with area sizes scaled proportional to frequencies.
  }}

\item{p_lbl}{A character code specifying the type of probability information (on edges) with
4 options:
  \enumerate{
  \item \code{"nam"} ... names of probabilities;
  \item \code{"num"} ... numeric values of probabilities (rounded to 3 decimals, default);
  \item \code{"mix"} ... names of essential probabilities, values of complements;
  \item \code{"min"} ... minimal labels: names of essential probabilities.
  }}

\item{show_accu}{Option for showing current
accuracy metrics \code{\link{accu}} on the margin of the plot.}

\item{w_acc}{Weighting parameter \code{w} used to compute
weighted accuracy \code{w_acc} in \code{\link{comp_accu_freq}}.

Various other options allow the customization of text labels and colors:}

\item{title_lbl}{Text label for current plot title.}

\item{popu_lbl}{Text label for current population \code{\link{popu}}.}

\item{cond_true_lbl}{Text label for current cases of \code{\link{cond_true}}.}

\item{cond_false_lbl}{Text label for current cases of \code{\link{cond_false}}.}

\item{dec_pos_lbl}{Text label for current cases of \code{\link{dec_pos}}.}

\item{dec_neg_lbl}{Text label for current cases of \code{\link{dec_neg}}.}

\item{hi_lbl}{Text label for hits \code{\link{hi}}.}

\item{mi_lbl}{Text label for misses \code{\link{mi}}.}

\item{fa_lbl}{Text label for false alarms \code{\link{fa}}.}

\item{cr_lbl}{Text label for correct rejections \code{\link{cr}}.}

\item{col_txt}{Color for text labels (in boxes).}

\item{cex_lbl}{Scaling factor for text labels (in boxes and on arrows).}

\item{col_boxes}{Colors of boxes (a single color or a vector with named colors matching the number of current boxes).
Default: Current color information contained in \code{\link{pal}}.}

\item{col_border}{Color of borders.
Default: \code{col_border = grey(.33, alpha = .99)}.}

\item{lwd}{Width of arrows.}

\item{box_lwd}{Width of boxes.}

\item{col_shadow}{Color of box shadows.
Default: \code{col_shadow = grey(.11, alpha = .99)}.}

\item{cex_shadow}{Scaling factor of shadows (values > 0 showing shadows).
Default: \code{cex_shadow = 0}.}
}
\value{
Nothing (NULL).
}
\description{
\code{plot_fnet} drew a network diagram of
frequencies (as nodes) and probabilities (as edges).
}
\details{
\code{plot_fnet} is deprecated -- please use \code{\link{plot_prism}} instead.
}
\examples{
plot_fnet()  # frequency network with default options (by = "cddc")

# alternative perspectives:
plot_tree(by = "cdac")  # frequency network by condition and accuracy
plot_fnet(by = "dccd")  # frequency network by decision and condition

# See plot_prism for details and additional options.

}
\seealso{
\code{\link{plot_prism}} is the new version of this function.

Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_area}}, \code{\link{plot_bar}},
  \code{\link{plot_curve}}, \code{\link{plot_icons}},
  \code{\link{plot_mosaic}}, \code{\link{plot_plane}},
  \code{\link{plot_prism}}, \code{\link{plot_tab}},
  \code{\link{plot_tree}}
}
\concept{visualization functions}
