% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_util.R
\name{is_extreme_prob_set}
\alias{is_extreme_prob_set}
\title{Verify that a set of probabilities describes an extreme case.}
\usage{
is_extreme_prob_set(prev, sens = NA, mirt = NA, spec = NA,
  fart = NA)
}
\arguments{
\item{prev}{The condition's prevalence value \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when is complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when is complement \code{sens} is provided.}

\item{spec}{The decision's specificity \code{\link{spec}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{FALSE}).
\code{spec} is optional when is complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}
}
\value{
A Boolean value:
\code{TRUE} if an extreme case is identified;
otherwise \code{FALSE}.
}
\description{
\code{is_extreme_prob_set} verifies that a set
of probabilities (i.e., \code{\link{prev}},
and \code{\link{sens}} or \code{\link{mirt}},
and \code{\link{spec}} or \code{\link{fart}})
describe an extreme case.
}
\details{
If \code{TRUE}, a warning message describing the
nature of the extreme case is printed to allow
anticipating peculiar effects (e.g., that
\code{\link{PPV}} or \code{\link{NPV}} values
cannot be computed or are \code{NaN}).

This function does not verify the type, range, sufficiency,
or consistency of its arguments. See \code{\link{is_prob}},
\code{\link{is_suff_prob_set}}, \code{\link{is_complement}},
\code{\link{is_valid_prob_pair}} and
\code{\link{is_valid_prob_set}} for these purposes.
}
\examples{
# Identify 6 extreme cases (+ 4 variants):
is_extreme_prob_set(1, 1, NA, 1, NA)       # => TRUE + warning: N true positives
plot_tree(1, 1, NA, 1, NA, N = 100)        # => illustrates this case

is_extreme_prob_set(1, 0, NA, 1, NA)       # => TRUE + warning: N false negatives
plot_tree(1, 0, NA, 1, NA, N = 200)        # => illustrates this case

sens <- .50
is_extreme_prob_set(0, sens, NA, 0, NA)    # => TRUE + warning: N false positives
plot_tree(0, sens, NA, 0, N = 300)         # => illustrates this case
# Variant:
is_extreme_prob_set(0, sens, NA, NA, 1)    # => TRUE + warning: N false positives
plot_tree(0, sens, NA, NA, 1, N = 350)     # => illustrates this case

sens <- .50
is_extreme_prob_set(0, sens, NA, 1)        # => TRUE + warning: N true negatives
plot_tree(0, sens, NA, NA, 1, N = 400)     # => illustrates this case
# Variant:
is_extreme_prob_set(0, sens, NA, NA, 0)    # => TRUE + warning: N true negatives
plot_tree(0, sens, NA, NA, 0, N = 450)     # => illustrates this case

prev <- .50
is_extreme_prob_set(prev, 0, NA, 1, NA)    # => TRUE + warning: 0 hi and 0 fa (0 dec_pos cases)
plot_tree(prev, 0, NA, 1, NA, N = 500)     # => illustrates this case
# # Variant:
is_extreme_prob_set(prev, 0, 0, NA, 0)     # => TRUE + warning: 0 hi and 0 fa (0 dec_pos cases)
plot_tree(prev, 0, NA, 1, NA, N = 550)     # => illustrates this case

prev <- .50
is_extreme_prob_set(prev, 1, NA, 0, NA)    # => TRUE + warning: 0 mi and 0 cr (0 dec_neg cases)
plot_tree(prev, 1, NA, 0, NA, N = 600)     # => illustrates this case
# # Variant:
is_extreme_prob_set(prev, 1, NA, 0, NA)    # => TRUE + warning: 0 mi and 0 cr (0 dec_neg cases)
plot_tree(prev, 1, NA, 0, NA, N = 650)     # => illustrates this case

}
\seealso{
\code{\link{is_valid_prob_pair}} verifies that a pair of probabilities can be complements;
\code{\link{is_valid_prob_set}} verifies the validity of a set of probability inputs;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{as_pc}} displays a probability as a percentage;
\code{\link{as_pb}} displays a percentage as probability

Other verification functions: \code{\link{is_complement}},
  \code{\link{is_freq}}, \code{\link{is_perc}},
  \code{\link{is_prob}}, \code{\link{is_suff_prob_set}},
  \code{\link{is_valid_prob_pair}},
  \code{\link{is_valid_prob_set}},
  \code{\link{is_valid_prob_triple}}
}
\concept{verification functions}
