# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

baseHaz_cpp <- function(alltimes, status, eXb, strata, predtimes, emaxtimes, nPatients, nStrata, cause, Efron) {
    .Call('riskRegression_baseHaz_cpp', PACKAGE = 'riskRegression', alltimes, status, eXb, strata, predtimes, emaxtimes, nPatients, nStrata, cause, Efron)
}

#' Apply cumsum in each column 
#'
#' @description Fast computation of apply(x,2,cumsum)
#' @param x A matrix.
#' @return A matrix of same size as x.
#' @author Thomas Alexander Gerds <tag@@biostat.ku.dk>
#' @examples
#' x <- matrix(1:8,ncol=2)
#' colCumSum(x)
#' @export
colCumSum <- function(x) {
    .Call('riskRegression_colCumSum', PACKAGE = 'riskRegression', x)
}

#' Apply crossprod and colSums 
#'
#' @description Fast computation of crossprod(colSums(X),Y) 
#' @param X A matrix with dimensions k*n. Hence the result of \code{colSums(X)} has length n.
#' @param Y A matrix with dimenions n*m. Can be a matrix with dimension m*n but then \code{transposeY} should be \code{TRUE}.
#' @param transposeY Logical. If \code{TRUE} transpose Y before matrix multiplication.
#' @return A vector of length m.
#' @author Thomas Alexander Gerds <tag@@biostat.ku.dk>
#' @examples
#' x <- matrix(1:8,ncol=2)
#' y <- matrix(1:16,ncol=8)
#' colSumsCrossprod(x,y,0)
#' 
#' x <- matrix(1:8,ncol=2)
#' y <- matrix(1:16,ncol=2)
#' colSumsCrossprod(x,y,1)
#' @export
colSumsCrossprod <- function(X, Y, transposeY) {
    .Call('riskRegression_colSumsCrossprod', PACKAGE = 'riskRegression', X, Y, transposeY)
}

calcE_cpp <- function(eventtime, status, eXb, X, p, add0) {
    .Call('riskRegression_calcE_cpp', PACKAGE = 'riskRegression', eventtime, status, eXb, X, p, add0)
}

ICbeta_cpp <- function(newT, neweXb, newX, newStatus, newIndexJump, S01, E1, time1, iInfo, p) {
    .Call('riskRegression_ICbeta_cpp', PACKAGE = 'riskRegression', newT, neweXb, newX, newStatus, newIndexJump, S01, E1, time1, iInfo, p)
}

IClambda0_cpp <- function(tau, ICbeta, newT, neweXb, newStatus, newStrata, newIndexJump, S01, E1, time1, lastTime1, lambda0, p, strata) {
    .Call('riskRegression_IClambda0_cpp', PACKAGE = 'riskRegression', tau, ICbeta, newT, neweXb, newStatus, newStrata, newIndexJump, S01, E1, time1, lastTime1, lambda0, p, strata)
}

predictCIF_cpp <- function(hazard, cumhazard, eXb_h, eXb_cumH, strata, newtimes, etimes, etimeMax, t0, nEventTimes, nNewTimes, nData, cause, nCause) {
    .Call('riskRegression_predictCIF_cpp', PACKAGE = 'riskRegression', hazard, cumhazard, eXb_h, eXb_cumH, strata, newtimes, etimes, etimeMax, t0, nEventTimes, nNewTimes, nData, cause, nCause)
}

#' Apply cumsum in each row 
#'
#' @description Fast computation of t(apply(x,1,cumsum))
#' @param x A matrix.
#' @return A matrix of same size as x.
#' @author Thomas Alexander Gerds <tag@@biostat.ku.dk>
#' @examples
#' x <- matrix(1:8,ncol=2)
#' rowCumSum(x)
#' @export
rowCumSum <- function(x) {
    .Call('riskRegression_rowCumSum', PACKAGE = 'riskRegression', x)
}

#' Apply crossprod and rowSums
#'
#' @description Fast computation of crossprod(rowSums(X),Y)
#' @param X A matrix with dimensions n*k. Hence the result of \code{rowSums(X)} has length n.
#' @param Y A matrix with dimenions n*m. Can be a matrix with dimension m*n but then \code{transposeY} should be \code{TRUE}.
#' @param transposeY Logical. If \code{TRUE} transpose Y before matrix multiplication.
#' @return A vector of length m.
#' @author Thomas Alexander Gerds <tag@@biostat.ku.dk>
#' @examples
#' x <- matrix(1:10,nrow=5)
#' y <- matrix(1:20,ncol=4)
#' rowSumsCrossprod(x,y,0)
#'
#' x <- matrix(1:10,nrow=5)
#' y <- matrix(1:20,ncol=5)
#' rowSumsCrossprod(x,y,1)
#' @export
rowSumsCrossprod <- function(X, Y, transposeY) {
    .Call('riskRegression_rowSumsCrossprod', PACKAGE = 'riskRegression', X, Y, transposeY)
}

#' @title Apply - by column
#'
#' @description Fast computation of sweep(X, MARGIN = 1, FUN = "-", STATS = center)
#' 
#' @param X A matrix.
#' @param center a numeric vector of length equal to the number of rows of \code{x}
#' 
#' @return A matrix of same size as X.
#' @author Brice Ozenne <broz@@sund.ku.dk>
#' @examples
#' x <- matrix(1,6,5)
#' sweep(x, MARGIN = 1, FUN = "-", STATS = 1:6)
#' colCenter_cpp(x, 1:6 )
#' 
#' @export
colCenter_cpp <- function(X, center) {
    .Call('riskRegression_colCenter_cpp', PACKAGE = 'riskRegression', X, center)
}

#' @title Apply - by row
#'
#' @description Fast computation of sweep(X, MARGIN = 2, FUN = "-", STATS = center)
#' 
#' @param X A matrix.
#' @param center a numeric vector of length equal to the number of rows of \code{x}
#' 
#' @return A matrix of same size as X.
#' @author Brice Ozenne <broz@@sund.ku.dk>
#' @examples
#' x <- matrix(1,6,5)
#' sweep(x, MARGIN = 2, FUN = "-", STATS = 1:5)
#' rowCenter_cpp(x, 1:5 )
#' 
#' rowCenter_cpp(x, colMeans(x) )
#' 
#' @export
rowCenter_cpp <- function(X, center) {
    .Call('riskRegression_rowCenter_cpp', PACKAGE = 'riskRegression', X, center)
}

#' @title Apply / by column
#'
#' @description Fast computation of sweep(X, MARGIN = 1, FUN = "/", STATS = scale)
#' 
#' @param X A matrix.
#' @param scale a numeric vector of length equal to the number of rows of \code{x}
#' 
#' @return A matrix of same size as X.
#' @author Brice Ozenne <broz@@sund.ku.dk>
#' @examples
#' x <- matrix(1,6,5)
#' sweep(x, MARGIN = 1, FUN = "/", STATS = 1:6)
#' colScale_cpp(x, 1:6 )
#' 
#' @export
colScale_cpp <- function(X, scale) {
    .Call('riskRegression_colScale_cpp', PACKAGE = 'riskRegression', X, scale)
}

#' @title Apply / by row
#'
#' @description Fast computation of sweep(X, MARGIN = 2, FUN = "/", STATS = scale)
#' 
#' @param X A matrix.
#' @param scale a numeric vector of length equal to the number of rows of \code{x}
#' 
#' @return A matrix of same size as X.
#' @author Brice Ozenne <broz@@sund.ku.dk>
#' @examples
#' x <- matrix(1,6,5)
#' sweep(x, MARGIN = 2, FUN = "/", STATS = 1:5)
#' rowScale_cpp(x, 1:5 )
#' 
#' rowScale_cpp(x, colMeans(x) )
#' 
#' @export
rowScale_cpp <- function(X, scale) {
    .Call('riskRegression_rowScale_cpp', PACKAGE = 'riskRegression', X, scale)
}

#' @title Apply * by column
#'
#' @description Fast computation of sweep(X, MARGIN = 1, FUN = "*", STATS = scale)
#' 
#' @param X A matrix.
#' @param scale a numeric vector of length equal to the number of rows of \code{x}
#' 
#' @return A matrix of same size as X.
#' @author Brice Ozenne <broz@@sund.ku.dk>
#' @examples
#' x <- matrix(1,6,5)
#' sweep(x, MARGIN = 1, FUN = "*", STATS = 1:6)
#' colMultiply_cpp(x, 1:6 )
#' 
#' @export
colMultiply_cpp <- function(X, scale) {
    .Call('riskRegression_colMultiply_cpp', PACKAGE = 'riskRegression', X, scale)
}

#' @title Apply * by row
#'
#' @description Fast computation of sweep(X, MARGIN = 2, FUN = "*", STATS = scale)
#' 
#' @param X A matrix.
#' @param scale a numeric vector of length equal to the number of rows of \code{x}
#' 
#' @return A matrix of same size as X.
#' @author Brice Ozenne <broz@@sund.ku.dk>
#' @examples
#' x <- matrix(1,6,5)
#' sweep(x, MARGIN = 2, FUN = "*", STATS = 1:5)
#' rowMultiply_cpp(x, 1:5 )
#' 
#' rowMultiply_cpp(x, 1/colMeans(x) )
#' 
#' @export
rowMultiply_cpp <- function(X, scale) {
    .Call('riskRegression_rowMultiply_cpp', PACKAGE = 'riskRegression', X, scale)
}

