% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irods-demo.R
\name{use_irods_demo}
\alias{use_irods_demo}
\alias{stop_irods_demo}
\title{Run Docker iRODS Demonstration Service}
\usage{
use_irods_demo(
  user = character(),
  pass = character(),
  recreate = FALSE,
  verbose = TRUE
)

stop_irods_demo()
}
\arguments{
\item{user}{Character vector for user name (defaults to "rods" admin)}

\item{pass}{Character vector for password (defaults to "rods" admin password)}

\item{recreate}{Boolean to indicate whether to recreate (reboot) the iRODS
demo server (defaults to \code{FALSE}). Recreating will destroy all content on
the current instance.}

\item{verbose}{Verbosity (defaults to \code{TRUE}).}
}
\value{
Invisible
}
\description{
Run an iRODS demonstration server with \code{use_irods_demo()} as a Docker
container instance. The function \code{stop_irods_demo()} stops the containers.
}
\details{
These functions are untested on Windows and macOS and require:
\itemize{
\item \code{bash}
\item \code{docker}
\item \code{docker-compose}
}
}
\examples{

if (interactive()) {

  # launch docker irods_demo containers (and possibly download images) with
  # default credentials
  use_irods_demo()

  # same but then with "alice" as user and "PASSword" as password
  use_irods_demo("alice", "PASSword")

  # stop containers
  stop_irods_demo()
}

}
\references{
https://github.com/irods/irods_demo
}
