% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert}
\alias{convert}
\title{Convert from one file format to another}
\usage{
convert(in_file, out_file, in_opts = list(), out_opts = list())
}
\arguments{
\item{in_file}{A character string naming an input file.}

\item{out_file}{A character string naming an output file.}

\item{in_opts}{A named list of options to be passed to \code{\link{import}}.}

\item{out_opts}{A named list of options to be passed to \code{\link{export}}.}
}
\value{
A character string containing the name of the output file (invisibly).
}
\description{
This function constructs a data frame from a data file using \code{\link{import}} and uses \code{\link{export}} to write the data to disk in the format indicated by the file extension.
}
\examples{
# create a file to convert
export(mtcars, dta_file <- tempfile(fileext = ".dta"))

# convert Stata to CSV and open converted file
convert(dta_file, csv_file <- tempfile(fileext = ".csv"))
head(import(csv_file))

# correct an erroneous file format
export(mtcars, csv_file2 <- tempfile(fileext = ".csv"), format = "tsv")
convert(csv_file2, csv_file, in_opts = list(format = "tsv"))

# convert serialized R data.frame to JSON
export(mtcars, rds_file <- tempfile(fileext = ".rds"))
convert(rds_file, json_file <- tempfile(fileext = ".json"))

# cleanup
unlink(csv_file)
unlink(csv_file2)
unlink(rds_file)
unlink(dta_file)
unlink(json_file)

\dontrun{\donttest{
# convert from the command line:
## Rscript -e "rio::convert('mtcars.dta', 'mtcars.csv')"
}}

}
\seealso{
\href{https://lbraglia.github.io/}{Luca Braglia} has created a Shiny app called \href{https://github.com/lbraglia/rioweb}{rioweb} that provides access to the file conversion features of rio through a web browser.
}
