% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introjs.R
\name{introjs}
\alias{hintjs}
\alias{introjs}
\alias{introjsUI}
\title{Initiate intro.js}
\usage{
introjs(session, options = list(), events = list())

hintjs(session, options = list(), events = list())

introjsUI(includeOnly = FALSE)
}
\arguments{
\item{session}{the Shiny session object (from the server function of the Shiny app)}

\item{options}{List of options to be passed to introJs}

\item{events}{List of text that are the body of a Javascript function}

\item{includeOnly}{Only include introjs files. For users who will write their own javascript}
}
\description{
Initiates an introduction via the intro.js library
}
\note{
For documentation on introJs options and events, see \url{https://github.com/usablica/intro.js/wiki/Documentation}.
}
\examples{
\dontrun{
library(rintrojs)
library(shiny)
ui <- shinyUI(fluidPage(
  introjsUI(),
  mainPanel(
    introBox(
      tableOutput("mtcars"),
      data.step = 1,
      data.intro = "This is the table"
    ),
    introBox(
      actionButton("btn","Intro"),
      data.step = 2,
      data.intro = "This is the button",
      data.hint = "Here is clue"
    )
  )))
server <- shinyServer(function(input, output, session) {

 hintjs(session, options = list("hintButtonLabel"="That was a hint"))

  output$mtcars <- renderTable({
    head(mtcars)
  })
  observeEvent(input$btn,
               introjs(session, options = list("nextLabel"="Onwards and Upwards"),
                                events = list("oncomplete"='alert("It is over")')))
})
# Run the application
shinyApp(ui = ui, server = server)
}
}
\seealso{
\code{\link{introBox}}
}

