% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectiveinfo.R
\name{effective_info}
\alias{effective_info}
\title{Effective Information}
\usage{
effective_info(tpm, inter = NULL)
}
\arguments{
\item{tpm}{Matrix specifying the transition probability matrix.}

\item{inter}{Vector specifying the intervention distribution.}
}
\value{
Numeric giving the effective information.
}
\description{
Compute the effective information from an n by n transition probability
matrix \code{tpm} given an intervention distribution \code{inter}.
If \code{inter} is \code{NULL}, then the uniform distribution over the n
states is used.
}
\examples{
# Compute effective information on a 3 by 3 tpm with uniform interventionn
tpm      <- matrix(0, nrow = 3, ncol = 3)
tpm[, 1] <- c(1.0 / 3, 1.0 / 3, 1.0 / 3)
tpm[, 2] <- c(0.250, 0.750, 0.000)
tpm[, 3] <- c(0.125, 0.500, 0.375)
inter    <- c(0.300, 0.250, 0.450)
effective_info(tpm, NULL)        # 0.202701

# .. and with a non-uniform intervention
inter    <- c(0.300, 0.250, 0.450)
effective_info(tpm, inter)       # 0.1724976
}
