% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.R
\name{shannon_mutual_info}
\alias{shannon_mutual_info}
\title{Shannon Mutual Information}
\usage{
shannon_mutual_info(p_xy, p_x, p_y, b = 2)
}
\arguments{
\item{p_xy}{Dist specifying the joint distribution.}

\item{p_x}{Dist specifying the \code{x}-marginal distribution.}

\item{p_y}{Dist specifying the \code{y}-marginal distribution.}

\item{b}{Numeric giving the base of the logarithm.}
}
\value{
Numeric giving the Shannon mutual information.
}
\description{
Compute the base-\code{b} mutual information between two random variables.
}
\examples{
xy <- Dist(c(10, 70, 15, 5))
x  <- Dist(c(80, 20))
y  <- Dist(c(25, 75))
shannon_mutual_info(xy, x, y)           # 0.2141709
shannon_mutual_info(xy, x, y, b = 3)    # 0.1351268
shannon_mutual_info(xy, x, y, b = 0)    # 0

}
