% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relativeentropy.R
\name{relative_entropy}
\alias{relative_entropy}
\title{Relative Entropy}
\usage{
relative_entropy(xs, ys, local = FALSE)
}
\arguments{
\item{xs}{Vector or matrix specifying one or more time series.}

\item{ys}{Vector or matrix specifying one or more time series.}

\item{local}{Boolean specifying whether to compute the local relative
entropy.}
}
\value{
Numeric giving the average relative entropy or a vector giving the
        local relative entropy.
}
\description{
Compute the average or local relative entropy between two time series
treating each as observations from a distribution.
}
\examples{
xs <- c(0, 1, 0, 0, 0, 0, 0, 0, 0, 1)
ys <- c(0, 1, 1, 1, 1, 0, 0, 1, 0, 0)
relative_entropy(xs, ys)       # 0.2780719
relative_entropy(ys, xs)       # 0.3219281

# [1]  0.6780719 -1.3219281
relative_entropy(xs, ys, local = TRUE)

xs <- c(0, 0, 0, 0)
ys <- c(0, 1, 1, 0)
relative_entropy(xs, ys)       # 1.0
relative_entropy(ys, xs)       # NaN
}
