% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-sofa.R
\encoding{UTF-8}
\name{sofa_score}
\alias{sofa_score}
\alias{sofa_resp}
\alias{sofa_coag}
\alias{sofa_liver}
\alias{sofa_cardio}
\alias{sofa_cns}
\alias{sofa_renal}
\title{SOFA score label}
\usage{
sofa_score(
  ...,
  worst_val_fun = max_or_na,
  explicit_wins = FALSE,
  win_length = hours(24L),
  keep_components = FALSE,
  interval = NULL
)

sofa_resp(..., interval = NULL)

sofa_coag(..., interval = NULL)

sofa_liver(..., interval = NULL)

sofa_cardio(..., interval = NULL)

sofa_cns(..., interval = NULL)

sofa_renal(..., interval = NULL)
}
\arguments{
\item{...}{Concept data, either passed as list or individual argument}

\item{worst_val_fun}{functions used to calculate worst values over windows}

\item{explicit_wins}{The default \code{FALSE} iterates over all time steps,
\code{TRUE} uses only the last time step per patient and a vector of times will
iterate over these explicit time points}

\item{win_length}{Time-frame to look back and apply the \code{worst_val_fun}}

\item{keep_components}{Logical flag indicating whether to return the
individual components alongside the aggregated score (with a suffix \verb{_comp}
added to their names)}

\item{interval}{Time series interval (only used for checking consistency
of input data, \code{NULL} will use the interval of the first data object)}
}
\value{
A \code{ts_tbl} object.
}
\description{
The SOFA (Sequential Organ Failure Assessment) score is a commonly used
assessment tool for tracking a patient's status during a stay at an ICU.
Organ function is quantified by aggregating 6 individual scores,
representing respiratory, cardiovascular, hepatic, coagulation, renal and
neurological systems. The function \code{sofa_score()} is used as callback
function to the \code{sofa} concept but is exported as there are a few arguments
that can used to modify some aspects of the presented SOFA implementation.
Internally, \code{sofa_score()} calls first \code{sofa_window()}, followed by
\code{sofa_compute()} and arguments passed as \code{...} will be forwarded to the
respective internally called function.
}
\details{
The function \code{sofa_score()} calculates, for each component, the worst value
over a moving window as specified by \code{win_length}, using the function
passed as \code{worst_val_fun}. The default functions \code{max_or_na()} return \code{NA}
instead of \code{-Inf/Inf} in the case where no measurement is available over an
entire window. When calculating the overall score by summing up components
per time-step, a \code{NA} value is treated as 0.

Building on separate concepts, measurements for each component are
converted to a component score using the definition by Vincent et. al.:\tabular{lllll}{
   \strong{SOFA score} \tab 1 \tab 2 \tab 3 \tab 4 \cr
   \strong{Respiration} \tab  \tab  \tab  \tab  \cr
   PaO\ifelse{latex}{\out{\textsubscript{2}}}{\ifelse{html
  }{\out{<sub>2</sub>}}{2}}/FiO\ifelse{latex
  }{\out{\textsubscript{2}}}{\ifelse{html
  }{\out{<sub>2</sub>}}{2}} [mmHg] \tab < 400 \tab < 300 \tab < 200 \tab < 100 \cr
   and mechanical ventilation \tab  \tab  \tab yes \tab yes \cr
   \strong{Coagulation} \tab  \tab  \tab  \tab  \cr
   Platelets [\ifelse{latex}{\out{$\times$}}{\ifelse{html
  }{\out{&times;}}{x}}10\ifelse{latex}{\out{\textsuperscript{3}}}{\ifelse{
  html}{\out{<sup>3</sup>}}{3}}/mm\ifelse{latex
  }{\out{\textsuperscript{3}}}{\ifelse{html
  }{\out{<sup>3</sup>}}{3}}] \tab < 150 \tab < 100 \tab < 50 \tab < 20 \cr
   \strong{Liver} \tab  \tab  \tab  \tab  \cr
   Bilirubin [mg/dl] \tab 1.2-1.9 \tab 2.0-5.9 \tab 6.0-11.9 \tab > 12.0 \cr
   \strong{Cardiovascular}\ifelse{latex}{\out{\textsuperscript{a}}}{\ifelse{html
  }{\out{<sup>a</sup>}}{a}} \tab  \tab  \tab  \tab  \cr
   MAP \tab < 70 mmHg \tab  \tab  \tab  \cr
   or dopamine \tab  \tab \ifelse{latex}{\out{$\le$}}{\ifelse{html
  }{\out{&leq;}}{<=}}                           5 \tab > 5 \tab > 15 \cr
   or dobutamine \tab  \tab any dose \tab  \tab  \cr
   or epinephrine \tab  \tab  \tab \ifelse{latex}{\out{$\le$}}{\ifelse{html
  }{\out{&leq;}}{<=}}                                      0.1 \tab > 0.1 \cr
   or norepinephrine \tab  \tab  \tab \ifelse{latex}{\out{$\le$}}{\ifelse{html
  }{\out{&leq;}}{<=}}                                      0.1 \tab > 0.1 \cr
   \strong{Central nervous system} \tab  \tab  \tab  \tab  \cr
   Glasgow Coma Score \tab 13-14 \tab 10-12 \tab 6-9 \tab < 6 \cr
   \strong{Renal} \tab  \tab  \tab  \tab  \cr
   Creatinine [mg/dl] \tab 1.2-1.9 \tab 2.0-3.4 \tab 3.5-4.9 \tab > 5.0 \cr
   or urine output [ml/day] \tab  \tab  \tab < 500 \tab < 200 \cr
}


\ifelse{latex}{\out{\textsuperscript{a}}}{\ifelse{html
}{\out{<sup>a</sup>}}{a}}Adrenergic agents administered for at least 1h
(doses given are in [\ifelse{latex}{\out{$\mu$}}{\ifelse{html
}{\out{&mu;}}{u}}g/kg \ifelse{latex}{\out{$\cdot$}}{\ifelse{html
}{\out{&middot;}}{.}} min]

At default, for each patient, a score is calculated for every time step,
from the first available measurement to the last. In instead of a regularly
evaluated score, only certain time points are of interest, this can be
specified using the \code{explicit_wins} argument: passing for example
\code{hours(24, 48)} will yield for every patient a score at hours 24 and 48
relative to the origin of the current ID system (for example ICU stay).
}
\references{
Vincent, J.-L., Moreno, R., Takala, J. et al. The SOFA (Sepsis-related Organ
Failure Assessment) score to describe organ dysfunction/failure. Intensive
Care Med 22, 707–710 (1996). https://doi.org/10.1007/BF01709751
}
