% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concept-utils.R
\name{new_itm}
\alias{new_itm}
\alias{is_itm}
\alias{init_itm}
\alias{init_itm.sel_itm}
\alias{init_itm.hrd_itm}
\alias{init_itm.col_itm}
\alias{init_itm.rgx_itm}
\alias{init_itm.fun_itm}
\alias{init_itm.itm}
\alias{new_item}
\alias{item}
\alias{as_item}
\alias{is_item}
\title{Data items}
\usage{
new_itm(src, ..., target = NA_character_, class = "sel_itm")

is_itm(x)

init_itm(x, ...)

\method{init_itm}{sel_itm}(x, table, sub_var, ids, callback = "identity_callback", ...)

\method{init_itm}{hrd_itm}(x, table, sub_var, ids, callback = "identity_callback", ...)

\method{init_itm}{col_itm}(x, table, unit_val = NULL, callback = "identity_callback", ...)

\method{init_itm}{rgx_itm}(x, table, sub_var, regex, callback = "identity_callback", ...)

\method{init_itm}{fun_itm}(x, callback, ...)

\method{init_itm}{itm}(x, ...)

new_item(x)

item(...)

as_item(x)

is_item(x)
}
\arguments{
\item{src}{The data source name}

\item{...}{Further specification of the \code{itm} object (passed to
\code{\link[=init_itm]{init_itm()}})}

\item{target}{Item target class (e.g. "id_tbl"), \code{NA} indicates no specific
class requirement}

\item{class}{Sub class for customizing \code{itm} behavior}

\item{x}{Object to query/dispatch on}

\item{table}{Name of the table containing the data}

\item{sub_var}{Column name used for subsetting}

\item{ids}{Vector of ids used to subset table rows. If \code{NULL}, all rows are
considered corresponding to the data item}

\item{callback}{Name of a function to be called on the returned data used
for data cleanup operations (or a string that evaluates to a function)}

\item{unit_val}{String valued unit to be used in case no \code{unit_var} is
available for the given table}

\item{regex}{String-valued regular expression which will be evaluated by
\code{\link[base:grep]{base::grepl()}} with \code{ignore.case = TRUE}}
}
\value{
Constructors and coercion functions return \code{itm} and \code{item} objects,
while inheritance tester functions return logical flags.
}
\description{
Item objects are used in \code{ricu} as a way to specify how individual data
items corresponding to clinical concepts (see also \code{\link[=concept]{concept()}}), such as
heart rate can be loaded from a data source. Several functions are
available for constructing \code{item} (and related auxiliary) objects either
from code or by parsing a JSON formatted concept dictionary using
\code{\link[=load_dictionary]{load_dictionary()}}.
}
\details{
In order to allow for a large degree of flexibility (and extensibility),
which is much needed owing to considerable heterogeneity presented by
different data sources, several nested S3 classes are involved in
representing a concept. An outline of this hierarchy can be described as
\itemize{
\item \code{\link[=concept]{concept}}: contains many \code{cncpt} objects (of potentially
differing sub-types), each comprising of some meta-data and an \code{item}
object
\item \code{item}: contains many \code{itm} objects (of potentially differing
sub-types), each encoding how to retrieve a data item.
}

The design choice for wrapping a vector of \code{itm} objects with a container
class \code{item} is motivated by the requirement of having several different
sub-types of \code{itm} objects (all inheriting from the parent type \code{itm}),
while retaining control over how this homogeneous w.r.t. parent type, but
heterogeneous w.r.t. sub-type vector of objects behaves in terms of S3
generic functions.

The following sub-classes to \code{itm} are available, each representing a
different data-scenario:
\itemize{
\item \code{sel_itm}: The most widely used item class is intended for the situation
where rows of interest can be identified by looking for occurrences of a
set of IDs (\code{ids}) in a column (\code{sub_var}). An example for this is heart
rate \code{hr} on mimic, where the IDs \code{211} and 220045\verb{are looked up in the}itemid\verb{column of}chartevents`.
\item \code{col_itm}: This item class can be used if no row-subsetting is required.
An example for this is heart rate (\code{hr}) on \code{eicu}, where the table
\code{vitalperiodic} contains an entire column dedicated to heart rate
measurements.
\item \code{rgx_itm}: As alternative to the value-matching approach of \code{sel_itm}
objects, this class identifies rows using regular expressions. Used for
example for insulin in \code{eicu}, where the regular expression \verb{^insulin (250.+)?\\\\(((ml|units)/hr)?\\\\)$} is matched against the \code{drugname} column
of \code{infusiondrug}. The regular expression is evaluated by \code{\link[base:grep]{base::grepl()}}
with \code{ignore.case = TRUE}.
\item \code{fun_itm}: Intended for the scenario where data of interest is not
directly available from a table, this \code{itm} class offers most flexibility.
A function can be specified as \code{callback} and this function will be called
with arguments \code{x} (the object itself), \code{patient_ids}, \code{id_type} and
\code{interval} (see \code{\link[=load_concepts]{load_concepts()}}) and is expected to return an object as
specified by the \code{target} entry.
\item \code{hrd_itm}: A special case of \code{sel_itm} for HiRID data where measurement
units are not available as separate column, but as separate table with
units fixed per concept.
}

All \code{itm} objects have to specify a data source (\code{src}) as well as a
sub-class. Further arguments then are specific to the respective sub-class
and encode information that define data loading, such as the table to
query, the column name and values to use for identifying relevant rows,
etc. The S3 generic function \code{init_itm()} is responsible for input
validation of class-specific arguments as well as class initialization. A
list of \code{itm} objects, created by calls to \code{new_itm()} can be passed to
\code{new_item} in order to instantiate an \code{item} object. An alternative
constructor for \code{item} objects is given by \code{item()} which calls \code{new_itm()}
on the passed arguments (see examples). Finally \code{as_item()} can be used
for coercion of related objects such as \code{list}, \code{concept}, and the like.
Several additional S3 generic functions exist for manipulation of
\code{item}-like objects but are marked \code{internal} (see
\link[=prepare_query]{item/concept utilities}).
}
\examples{
if (require(mimic.demo)) {
gluc <- item("mimic_demo", "labevents", "itemid", list(c(50809L, 50931L)),
             unit_var = TRUE, target = "ts_tbl")

is_item(gluc)

all.equal(gluc, as_item(load_dictionary("mimic_demo", "glu")))

hr1 <- new_itm(src = "mimic_demo", table = "chartevents",
               sub_var = "itemid", ids = c(211L, 220045L))

hr2 <- item(src = c("mimic_demo", "eicu_demo"),
            table = c("chartevents", "vitalperiodic"),
            sub_var = list("itemid", NULL),
            val_var = list(NULL, "heartrate"),
            ids = list(c(211L, 220045L), NULL),
            class = c("sel_itm", "col_itm"))

identical(as_item(hr1), hr2[1])
identical(new_item(list(hr1)), hr2[1])
}

}
