% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{pMCtoF14C}
\alias{pMCtoF14C}
\title{Calculate pMC ages from F14C values.}
\usage{
pMCtoF14C(pMC, er = NULL, roundby = NA)
}
\arguments{
\item{pMC}{Reported mean of the F14C}

\item{er}{Reported error of the pMC value. Returns just the mean if left empty.}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=NA}, no rounding.}
}
\value{
The F14C values from the pMC values. Basically the original values divided by 100.
}
\description{
Calculate pMC values from F14C values of radiocarbon dates.
}
\details{
Post-bomb dates are often reported as F14C (between 0 at c. 55 kcal BP and 1 at c. AD 1950). Since software such as Bacon expects radiocarbon ages,
 this function can be used to calculate radiocarbon ages from F14C values. The reverse function is \link{age.F14C}.
}
\examples{
  pMCtoF14C(110, 5)
}
