% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.dates}
\alias{draw.dates}
\title{add calibrated distributions to a plot.}
\usage{
draw.dates(
  age,
  error,
  depth = c(),
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  thiscurve = c(),
  oncurve = FALSE,
  realm = "C",
  reservoir = c(),
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  prob = 0.95,
  threshold = 0.001,
  BCAD = FALSE,
  draw.hpd = TRUE,
  hpd.border = NA,
  hpd.col = rgb(0, 0, 1, 0.7),
  cal.hpd.col = rgb(0, 0.5, 0.5, 0.35),
  rounded = 0.1,
  every = 1,
  mirror = TRUE,
  up = TRUE,
  draw.base = TRUE,
  col = rgb(0, 0, 1, 0.3),
  border = rgb(0, 0, 1, 0.5),
  cal.col = rgb(0, 0.5, 0.5, 0.35),
  cal.border = rgb(0, 0.5, 0.5, 0.35),
  add = FALSE,
  ka = FALSE,
  rotate.axes = FALSE,
  ex = 0.8,
  normalise = TRUE,
  cc.col = rgb(0, 0.5, 0, 0.5),
  cc.border = rgb(0, 0.5, 0, 0.5),
  cc.resample = 5,
  age.lab = c(),
  age.lim = c(),
  age.rev = FALSE,
  d.lab = c(),
  d.lim = c(),
  d.rev = TRUE,
  labels = c(),
  label.x = 1,
  label.y = c(),
  label.cex = 0.8,
  label.col = border,
  label.offset = c(0, 0),
  label.adj = c(1, 0),
  label.rot = 0,
  cc.dir = NULL,
  dist.res = 100,
  ...
)
}
\arguments{
\item{age}{Mean of the uncalibrated C-14 age (or multiple ages).}

\item{error}{Error of the uncalibrated C-14 age (or ages).}

\item{depth}{Depth(s) of the date(s). Defaults to their relative positions if no depths are provided.}

\item{cc}{Calibration curve for C-14 dates (1, 2, 3, or 4, or, e.g., "IntCal20", "Marine20", "SHCal20", "nh1", "sh3", or "mixed"). If there are multiple dates but all use the same calibration curve, one value can be provided.}

\item{postbomb}{Whether or not this is a postbomb age. Defaults to FALSE.}

\item{deltaR}{Age offset (e.g. for marine samples). Can also be provided as option 'reservoir'.}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation). Can also be provided within option 'reservoir'.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error). Defaults to c().}

\item{oncurve}{Whether or not to plot the calibration curve and then plot the dates onto this curve. Defaults to FALSE.}

\item{realm}{If oncurve is used, by default the calibration curve is plotted in the C14 age realm. Alternatively, it can be provided as \code{realm="F14C"} or \code{realm="pMC"}}

\item{reservoir}{Reservoir age, or reservoir age and age offset.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2009).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{prob}{Probability confidence intervals (between 0 and 1).}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=0.001}.}

\item{BCAD}{Use BC/AD or cal BP scale (default cal BP).}

\item{draw.hpd}{Whether or not to draw the hpd ranges as a line}

\item{hpd.border}{Colour of the border of the hpd intervals. Not drawn by default.}

\item{hpd.col}{Colour of the hpd rectangle for all dates or radiocarbon dates}

\item{cal.hpd.col}{Colour of the hpd rectangle for cal BP dates}

\item{rounded}{Rounding for probabilities of reported hpd ranges. Defaults to 1 decimal.}

\item{every}{Yearly precision of hpds (defaults to \code{every=1}).}

\item{mirror}{Plot distributions mirrored, a bit like a swan. Confuses some people but looks nice to the author so is the default.}

\item{up}{If mirror is set to FALSE, the distribution can be plotted facing upwards or downwards.}

\item{draw.base}{By default, the base of the calibrated distributions is plotted. This can be avoided by supplying \code{draw.base=FALSE} as an option.}

\item{col}{Colour of the inside of the distribution}

\item{border}{Colour of the border of the distribution}

\item{cal.col}{Colour of the inside of distribution of non-radiocarbon dates that didn't need calibration}

\item{cal.border}{Colour of the border of the distribution of non-radiocarbon dates that didn't need calibration}

\item{add}{Whether or not to add the dates to an existing plot. If set to FALSE (default), a plot will be set up.}

\item{ka}{Whether or not to plot ages as thousands of years. Defaults to \code{ka=FALSE}.}

\item{rotate.axes}{By default, the calendar age axis is plotted on the horizontal axis, and depth/position on the vertical one. Use \code{rotate.axes=TRUE} to rotate the axes.}

\item{ex}{Exaggeration of the height of the distribution, defaults to \code{ex=1}.}

\item{normalise}{If TRUE, the age distributions are normalised by plotting each distribution with the same total area. Precise dates will therefore peak higher than less precise dates (default). If \code{normalise=FALSE}, the peak of each date will be drawn at the same height.}

\item{cc.col}{Colour of the calibration curve. Default semi-transparent darkgreen.}

\item{cc.border}{Colour of the edges of the calibration curve. Default semi-transparent darkgreen.}

\item{cc.resample}{The IntCal20 curves have different densities (every year between 0 and 5 kcal BP, then every 5 yr up to 15 kcal BP, then every 10 yr up to 25 kcal BP, and then every 20 yr up to 55 kcal BP). If calibrated ages span these density ranges, their drawn heights can differ, as can their total areas (which should ideally all sum to the same size). To account for this, resample to a constant time-span, using, e.g., \code{cc.resample=5} for 5-yr timespans.}

\item{age.lab}{Title of the calendar axis (if present)}

\item{age.lim}{Limits of the calendar axis (if present)}

\item{age.rev}{Reverse the age axis. Defaults to TRUE}

\item{d.lab}{Title of the vertical axis (if present)}

\item{d.lim}{Limits of the vertical axis (if present)}

\item{d.rev}{Reverse the y-axis. Defaults to TRUE}

\item{labels}{Add labels to the dates. Empty by default.}

\item{label.x}{Horizontal position of the date labels. By default draws them before the youngest age (1), but can also draw them after the oldest age (2), or above its mean (3).}

\item{label.y}{Vertical positions of the depths/labels. Defaults to 0 (or 1 if label.x is 3 or 4).}

\item{label.cex}{Size of labels.}

\item{label.col}{Colour of the labels. Defaults to the colour given to the borders of the dates.}

\item{label.offset}{Offsets of the positions of the depths/labels, giving the x and y offsets. Defaults to c(0,0).}

\item{label.adj}{Justification of the labels. Follows R's adj option: A value of "0" produces left-justified text, "0.5" (the default) centered text and "1" right-justified text.}

\item{label.rot}{Rotation of the label. 0 by default (horizontal).}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{dist.res}{Resolution of the distribution polygons. Defaults to \code{dist.res=100}.}

\item{...}{Additional plotting options}
}
\value{
A plot of the (calibrated) dates
}
\description{
Add individual or multiple calibrated dates to a plot.
}
\examples{
  plot(0, xlim=c(500,0), ylim=c(0, 2))
  draw.dates(130, 20, depth=1) 
  x <- sort(runif(10, 1000, 10000)) # draw 10 random calendar ages
  cc <- rintcal::ccurve() # get the calibration curve
  y <- approx(cc[,1], cc[,2], x)$y # find the IntCal 14C ages
  er <- .01 * y
  draw.dates(y, er, 1:length(x))
  # or draw on the calibration curve
  draw.dates(y, er, y, d.lab="Radiocarbon age (BP)")
  draw.ccurve(add=TRUE, cc1.col=rgb(0,.5,0,.5))
}
