% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{younger}
\alias{younger}
\title{Find the probability of a calibrated date being of a certain age or younger than it}
\usage{
younger(
  x,
  y,
  er,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  normal = TRUE,
  as.F = FALSE,
  t.a = 3,
  t.b = 4,
  BCAD = FALSE,
  threshold = 0
)
}
\arguments{
\item{x}{The year of interest, in cal BP by default.}

\item{y}{The radiocarbon date's mean.}

\item{er}{The radiocarbon date's lab error.}

\item{cc}{calibration curve for the radiocarbon date(s) (see the \code{rintcal} package).}

\item{postbomb}{Whether or not to use a postbomb curve (see \code{caldist()}).}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{as.F}{Whether or not to calculate ages in the F14C realm. Defaults to \code{as.F=FALSE}, which uses the C14 realm.}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=0}.}
}
\value{
The probability of a date being of a certain calendar age or younger than it.
}
\description{
Find the probability that a sample is of a certain calendar age x or younger than it, by calculating the proportion of the calibrated distribution up to and including x (i.e., summing the calibrated distribution up to year x).
}
\details{
The function can only deal with one date at a time.
}
\examples{
younger(2800, 2450, 20)
younger(2400, 2450, 20)
calibrate(160, 20, BCAD=TRUE)
younger(1750, 160, 20, BCAD=TRUE)
}
\author{
Maarten Blaauw
}
