% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{muck}
\alias{muck}
\title{Calculate the amount of muck/contamination to explain an observed C14 age}
\usage{
muck(
  y.obs,
  y.obs.er = 0,
  y.target,
  y.target.er = 0,
  F.contam = 1,
  F.contam.er = 0,
  MC = TRUE,
  its = 10000,
  roundby = 1,
  decimals = 3,
  visualise = TRUE,
  talk = TRUE,
  eq.x = 5,
  eq.y = c(),
  eq.size = 0.8,
  target.col = "darkgreen",
  observed.col = "blue",
  contamination.col = "red",
  target.pch = 20,
  observed.pch = 18,
  contamination.pch = 17,
  true.name = "target",
  xlab = "contamination (\%)",
  ylab = "F14C",
  ylim = c(),
  bty = "l"
)
}
\arguments{
\item{y.obs}{The observed radiocarbon age}

\item{y.obs.er}{The error of the observed radiocarbon age}

\item{y.target}{the target radiocarbon age}

\item{y.target.er}{The error of the target radiocarbon age. Not taken into account in the calculations.}

\item{F.contam}{the F14C of the contamination. Set at 1 for carbon of modern radiocarbon age, at 0 for 14C-free carbon, or anywhere inbetween.}

\item{F.contam.er}{The error of the contamination. Defaults to 0.}

\item{MC}{Whether or not to use Monte Carlo iterations to estimate the values. Defaults to TRUE, because it treats uncertainties better than if set to FALSE.}

\item{its}{Amount of iterations to use if MC=TRUE. Defaults to 10,000.}

\item{roundby}{Rounding of the output for C14 ages. Defaults to 1 decimal.}

\item{decimals}{Rounding of the output. Since details matter here, the default is to provide 5 decimals.}

\item{visualise}{By default, a plot is made to visualise the target and observed F14C values, together with the inferred contamination.}

\item{talk}{Whether or not to report the calculations made. Defaults to \code{talk=TRUE}.}

\item{eq.x}{Leftmost location of the equation. Defaults to \code{eq.x=5}. Can be set to values outside of (0,100) to make the equation invisible.}

\item{eq.y}{Vertical location of the equation. Defaults to the top of the graph.}

\item{eq.size}{Size of the font of the equation. In case the equation gets jumbled up upon resizing of a graphical device, just issue the previous `clean` command again. Defaults to \code{eq.size=0.8}.}

\item{target.col}{Colour for the target/true values. Defaults to darkgreen.}

\item{observed.col}{Colour for the observed values. Defaults to blue.}

\item{contamination.col}{Colour for the contamination values. Defaults to red.}

\item{target.pch}{Icon for the target. Defaults to a filled circle.}

\item{observed.pch}{Icon for the observed. Defaults to a diamond}

\item{contamination.pch}{Icon for the contamination. Defaults to a triangle.}

\item{true.name}{Name of the label of the true/target date}

\item{xlab}{Name of the x-axis. Defaults to 'contamination (\%)'.}

\item{ylab}{Name of the y-axis. Defaults to 'F14C'.}

\item{ylim}{Limits of the y-axis. Calculated automatically by default.}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="l"}.}
}
\value{
The required contamination (as percentage), as well as a plot
}
\description{
Given an observed and a target radiocarbon age, calculate the amount of contamination required to explain the observed age.
}
\details{
Whereas the function takes true/target and observed C14 ages as input and percentage contamination as output, internal calculations are done in the F14C realm and using contamination fractions (between 0 and 1). The central calculation is `frac = (F_obs - F_true) / (F_contam - F_true)`, where `frac` is the fraction of contamination to explain how we went from the observed to the true C14 age, `F_obs` is the observed C14 age in F14C, `F_true` is the true or target age in F14C, `F_contam` is the F value of the contamination. In some extreme cases (e.g., if dividing by zero), the calculation will spit out unexpected results. Messages will be provided in most of these cases.
}
\examples{
  muck(600, 30, 2000, 0, 1, .01)
}
\author{
Maarten Blaauw
}
