% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coeffTable.R
\name{kin2deg}
\alias{kin2deg}
\title{Degree of relationship}
\usage{
kin2deg(kin, unrelated = Inf)
}
\arguments{
\item{kin}{A vector of kinship coefficients, i.e., numbers in \verb{[0, 1]}.}

\item{unrelated}{The conversion of unrelated individuals (\code{kin = 0}).
Mathematically this corresponds to \code{degree = Inf}, but in some situations
\code{degree = NA} or something else might be preferable.}
}
\value{
An integer vector of the same length as \code{kin}.
}
\description{
Converts a vector of kinship coefficients to "degrees of relationship", as
used by some software for relatedness inference (e.g. KING).
}
\details{
The implementation uses the conversion formula \deqn{deg = round(-log2(kin) -
1).}
The first degrees correspond to the following approximate kinship ranges:
\itemize{
\item \verb{[0.354, 1]}: 0th degree (MZ twins or duplicates)
\item \verb{[0.177, 0.354)}: 1st degree (parent-offspring, full siblings)
\item \verb{[0.0884, 0.177)}: 2nd degree (half sibs, grandparent-grandchild, avuncular)
\item \verb{[0.0442, 0.0884)} 3rd degree (half-avuncular, first cousins, great-grandparent etc)
}
}
\examples{
x = cousinPed(1)

# Kinship matrix
k = kinship(x)

# Degrees
deg = kin2deg(k)
deg

# First cousins are 3rd degree
stopifnot(deg['7', '8'] == 3)

}
\references{
KING manual with thresholds for relationship degrees:
\url{https://www.kingrelatedness.com/manual.shtml}
}
\seealso{
\code{\link[=kinship]{kinship()}}, \code{\link[=coeffTable]{coeffTable()}}
}
