% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdTriangle.R
\name{showInTriangle}
\alias{showInTriangle}
\title{Add points to the IBD triangle}
\usage{
showInTriangle(
  kappa,
  new = TRUE,
  col = "blue",
  cex = 1,
  pch = 4,
  lwd = 2,
  labels = FALSE,
  colLab = col,
  cexLab = 0.8,
  pos = 1,
  adj = NULL,
  keep.par = TRUE,
  ...
)
}
\arguments{
\item{kappa}{Coordinates of points to be plotted in the IBD triangle. Valid
input types are:
\itemize{
\item A numerical vector of length 2 or 3. In the latter case \code{kappa[c(1, 3)]}
is used.
\item A matrix of data frame, whose column names must include either \code{k0} and
\code{k2}, \code{kappa0} and \code{kappa2}, or \code{ibd0} and \code{ibd2}.
\item A list (and not a data frame), in which case an attempt is made to bind
the elements row-wise.
}}

\item{new}{A logical indicating if a new triangle should be drawn.}

\item{col, cex, pch, lwd}{Parameters passed onto \code{\link[=points]{points()}}.}

\item{labels}{A character of same length as the number of points, or a single
logical \code{TRUE} or \code{FALSE}. If \code{TRUE}, an attempt is made to create labels
by pasting columns \code{ID1} and \code{ID2} in \code{kappa}, if these exist. By default,
no labels are plotted.}

\item{colLab, cexLab, pos, adj}{Parameters passed onto \code{\link[=text]{text()}} (if \code{labels} is
non-NULL).}

\item{keep.par}{A logical. If TRUE, the graphical parameters are not reset
after plotting, which may be useful for adding additional annotation.}

\item{\dots}{Plot arguments passed on to \code{ibdTriangle()}.}
}
\value{
None
}
\description{
Utility function for plotting points in the IBD triangle.
}
\examples{
showInTriangle(c(3/8, 1/8), label = "3/4 siblings", pos = 1)

}
\author{
Magnus Dehli Vigeland
}
