% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_relatedness.R
\name{external_coefs}
\alias{external_coefs}
\alias{kinship2_kinship}
\alias{kinship2_kinshipX}
\alias{kinship2_inbreeding}
\alias{kinship2_inbreedingX}
\alias{idcoefs}
\alias{idcoefs2}
\title{Relatedness coefficients by other programs}
\usage{
kinship2_kinship(x, ids = NULL)

kinship2_kinshipX(x, ids = NULL)

kinship2_inbreeding(x)

kinship2_inbreedingX(x)

idcoefs(x, ids)

idcoefs2(x, ids, verbose = FALSE, cleanup = TRUE)
}
\arguments{
\item{x}{A pedigree, in the form of a \code{\link[pedtools:ped]{pedtools::ped}} object.}

\item{ids}{A integer vector of length 2.}

\item{verbose}{A logical, indicating if messages from IdCoefs should be
printed.}

\item{cleanup}{A logical: If TRUE, the pedfile and sample file created for
the IdCoefs run are deleted automatically.}
}
\value{
For \code{kinship2_inbreeding()} and \code{kinship2_inbreedingX()}, a named
numerical vector with the inbreeding coefficients and ID labels as names.

For \code{kinship2_kinship()} and \code{kinship2_kinshipX()}, either a single numeric
(if \code{ids} is a pair of pedigree members) or the whole kinship matrix, with
the ID labels as dimnames.

For \code{jaquard()} and \code{jaquard2()}, a numerical vector of length 9 (in the
standard order of Jacquard's condensed identity coefficients).
}
\description{
Wrappers for functions in other packages or external programs, computing
various relatedness coefficients.
}
\details{
\code{kinship2_inbreeding()} and \code{kinship2_kinship()} are wrappers of
\code{\link[kinship2:kinship]{kinship2::kinship()}} with the parameter \code{chrtype = "autosome"}.

Similarly ,\code{kinship2_inbreedingX()} and \code{kinship2_kinshipX()} wrap
\code{\link[kinship2:kinship]{kinship2::kinship()}} using \code{chrtype = "x"}.

\code{idcoefs()} wraps \code{\link[identity:identity.coefs]{identity::identity.coefs()}}, which is an R interface for
the C program \code{IdCoefs} written by Mark Abney (2009). The \code{identity.coefs()}
function sometimes causes R to crash, hence I have provided an alternative
wrapper, \code{idcoefs2}, which executes an external call to the original C
program \code{IdCoefs} (version 2.1.1). For this to work, \code{IdCoefs} must be
installed on the computer (see link in the References section below) and the
executable placed in a folder included in the PATH variable. The
\code{idcoefs2()} wrapper works by writing the necessary files to disk and
calling \code{IdCoefs} via \code{\link[=system]{system()}}.
}
\examples{
# A random pedigree with 2 founders and 5 matings
p = pedtools::randomPed(g = 5, founders = 2, seed = 111)

# Check that ribd agrees with kinship2 package
kinship_k2 = kinship2_kinship(p)
kinship_ribd = kinship(p)
stopifnot(identical(kinship_k2, kinship_ribd))

# Check on X also
kinshipX_k2 = kinship2_kinshipX(p)
kinshipX_ribd = kinshipX(p)
stopifnot(identical(kinshipX_k2, kinshipX_ribd))

}
\references{
Abney, Mark (2009). \emph{A graphical algorithm for fast computation
of identity coefficients and generalized kinship coefficients.}
Bioinformatics, 25, 1561-1563.
\url{http://home.uchicago.edu/~abney/abney_web/Software.html}
}
\seealso{
\code{\link[kinship2:kinship]{kinship2::kinship()}}, \code{\link[identity:identity.coefs]{identity::identity.coefs()}}
}
\author{
Magnus Dehli Vigeland
}
