% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persistence-diagram.R
\name{autoplot.persistence_diagram}
\alias{autoplot.persistence_diagram}
\title{Plot for \code{\link{persistence_diagram}} objects}
\usage{
\method{autoplot}{persistence_diagram}(
  object,
  dimension = NULL,
  alpha = 0.6,
  max_intervals = 20000,
  legend = FALSE,
  greyblock = TRUE,
  n = 10L,
  type = c("barcode", "diagram", "density"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link{persistence_diagram}}.}

\item{dimension}{An integer value specifying the homology dimension to
visualize. Defaults to \code{NULL} in which case the dimension is retrieved
directly in the \link{persistence_diagram} object.}

\item{alpha}{A numeric value between 0 and 1 specifying the transparency of
points and lines in the plot. Defaults to \code{0.6}.}

\item{max_intervals}{An integer value specifying the maximal number of
intervals to display. Selected intervals are those with the longest
lifetime. Set it to \code{0} to see them all. Defaults \code{20000L}.}

\item{legend}{A boolean value specifying whether to display the legend about
the homology dimension(s). Defaults to \code{FALSE}.}

\item{greyblock}{A boolean value specifying whether to display a grey lower
triangle in the diagram representation for nicer output. Defaults to
\code{TRUE}.}

\item{n}{An integer value specifying the number of bins for plotting the
diagram as a density. Defaults to \code{10L}.}

\item{type}{A string specifyfing the type of representation. Choices are
\code{"barcode"}, \code{"diagram"} or \code{"density"}. Defaults to \code{"barcode"}.}

\item{...}{Other parameters to be passed on to next methods.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
This function creates a visualization of a persistence diagram and returns
the corresponding \link[ggplot2:ggplot]{ggplot2::ggplot} object which enable further customization
of the plot.
}
\examples{
\dontshow{if (requireNamespace("ggplot2", quietly = TRUE) && requireNamespace("tibble", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pd <- as_persistence_diagram(tibble::tibble(
  birth = 0,
  death = 1,
  dimension = 0
))
ggplot2::autoplot(pd)
\dontshow{\}) # examplesIf}
}
