% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{demean}
\alias{demean}
\title{Demean Standardize}
\usage{
demean(data)
}
\arguments{
\item{data}{A list of numeric vectors (multi-variables) for median absolute deviation}
}
\value{
A list of numeric vectors from demean
}
\description{
The mean for each variable is subtracting from each observation resulting in mean zero.
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
crm_prp <- guerry_df['Crm_prp'][,1] # get values of variable "crm_prp"
data <- list(crm_prs, crm_prp)
demean(data)
}
