% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComByReg.R
\name{ComByReg}
\alias{ComByReg}
\title{Get Cities by Region}
\usage{
ComByReg(codeRegion, postal = FALSE)
}
\arguments{
\item{codeRegion}{a numeric vector with a region INSEE code.}

\item{postal}{wether or not to include postal codes. Default is FALSE.}
}
\value{
Returns a data.frame with names of the cities, INSEE codes, postal codes, INSEE department codes, INSEE region codes, population of the cities (approx), surface of the cities (in hectares), lat and long (WGS-84).
}
\description{
Get informations about all the cities in a French region by its INSEE code. Please note that this package works only with French cities.
}
\details{
Takes a region INSEE ode, returns a data.frame with the available values.
}
\note{
If you don't know the INSEE code of the region you're looking for, you can find it by using the \code{\link{RegByName}} function.
}
\examples{
ComByReg(codeRegion = 53) 
}

