% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genie_functions.R
\name{power_analysis}
\alias{power_analysis}
\title{Performs estimates of power to detect effects of alleles at different
read fractions, given the variance observed in the del_result replicates.}
\usage{
power_analysis(del_result, allele_min_reads = 100, WT_fraction = NA)
}
\arguments{
\item{del_result}{The result from deletion_analysis}

\item{allele_min_reads}{The minimum number of reads that a deletion allele must have across all replicates to be included.}

\item{WT_fraction}{If specified, then the model will assume this fraction of WT reads}
}
\value{
Returns...
}
\description{
Performs estimates of power to detect effects of alleles at different
read fractions, given the variance observed in the del_result replicates.
}
\examples{
# Note: First run deletion_analysis()
# mul1_del_results is a pre-loaded result

pwr = power_analysis(mul1_del_results[[1]])
power_plots(mul1_del_results[[1]])
}
\seealso{
\code{\link{deletion_analysis}}

\code{\link{power_plots}}
}
