% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deprecated.R
\name{ee_subsetting}
\alias{ee_subsetting}
\alias{[[.ee.imagecollection.ImageCollection}
\alias{[[<-.ee.imagecollection.ImageCollection}
\alias{[[.ee.image.Image}
\alias{[[<-.ee.image.Image}
\title{Extract or replace parts of and ee$ImageCollection}
\usage{
\method{[[}{ee.imagecollection.ImageCollection}(x, index)

\method{[[}{ee.imagecollection.ImageCollection}(x, index) <- value

\method{[[}{ee.image.Image}(x, index)

\method{[[}{ee.image.Image}(x, index) <- value
}
\arguments{
\item{x}{ee$ImageCollection or ee$Image.}

\item{index}{Integer. Index specifying elements to extract or replace.}

\item{value}{ee$ImageCollection or ee$Image to replace in.}
}
\description{
Extract or replace parts of and ee$ImageCollection
}
\examples{
\dontrun{
library(rgee)
library(sf)

ee_Initialize(gcs = TRUE, drive = TRUE)

# Define a Image or ImageCollection: Terraclimate
terraclimate <- ee$ImageCollection("IDAHO_EPSCOR/TERRACLIMATE") \%>\%
  ee$ImageCollection$filterDate("2001-01-01", "2002-01-01")

# Define temperature Vis parameters
maximumTemperatureVis <- list(
  min = -300.0,
  max = 300.0,
  palette = c(
    '1a3678', '2955bc', '5699ff', '8dbae9', 'acd1ff', 'caebff', 'e5f9ff',
    'fdffb4', 'ffe6a2', 'ffc969', 'ffa12d', 'ff7c1f', 'ca531a', 'ff0000',
    'ab0000'
  )
)

Map$setCenter(71.72, 52.48, 2)
m1 <- Map$addLayer(terraclimate[[2]][["tmmx"]], maximumTemperatureVis)

terraclimate[[2]] <- terraclimate[[2]]*1.4
m2 <- Map$addLayer(terraclimate[[2]][["tmmx"]], maximumTemperatureVis)
m1 | m2
}
}
