% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_list.R
\name{occ_download_list}
\alias{occ_download_list}
\title{Lists the downloads created by a user.}
\usage{
occ_download_list(
  user = NULL,
  pwd = NULL,
  limit = 20,
  start = 0,
  curlopts = list()
)
}
\arguments{
\item{user}{(character) User name within GBIF's website. Required. See
Details.}

\item{pwd}{(character) User password within GBIF's website. Required. See
Details.}

\item{limit}{(integer/numeric) Number of records to return. Default: 20,
Max: 1000}

\item{start}{(integer/numeric) Record number to start at. Default: 0}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\value{
a list with two slots:
\itemize{
\item meta: a single row data.frame with columns: \code{offset}, \code{limit},
\code{endofrecords}, \code{count}
\item results: a tibble with the nested data flattened, with many
columns with the same \code{request.} prefix
}
}
\description{
Lists the downloads created by a user.
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\examples{
\dontrun{
occ_download_list(user="sckott")
occ_download_list(user="sckott", limit = 5)
occ_download_list(user="sckott", start = 21)
}
}
\seealso{
Other downloads: 
\code{\link{download_predicate_dsl}},
\code{\link{occ_download_cancel}()},
\code{\link{occ_download_dataset_activity}()},
\code{\link{occ_download_datasets}()},
\code{\link{occ_download_get}()},
\code{\link{occ_download_import}()},
\code{\link{occ_download_meta}()},
\code{\link{occ_download_queue}()},
\code{\link{occ_download_wait}()},
\code{\link{occ_download}()}
}
\concept{downloads}
