% Generated by roxygen2 (4.0.1): do not edit by hand
\name{name_suggest}
\alias{name_suggest}
\title{A quick and simple autocomplete service that returns up to 20 name usages by
doing prefix matching against the scientific name. Results are ordered by relevance.}
\usage{
name_suggest(q = NULL, datasetKey = NULL, rank = NULL, fields = NULL,
  start = NULL, limit = 20, callopts = list())
}
\arguments{
\item{callopts}{Pass on options to httr::GET for more refined control of
http calls, and error handling}

\item{limit}{Number of records to return}

\item{start}{Record number to start at}

\item{q}{(character, required) Simple search parameter. The value for this parameter can be a
simple word or a phrase. Wildcards can be added to the simple word parameters only,
e.g. q=*puma*}

\item{datasetKey}{(character) Filters by the checklist dataset key (a uuid, see examples)}

\item{rank}{(character) A taxonomic rank. One of class, cultivar, cultivar_group, domain, family,
form, genus, informal, infrageneric_name, infraorder, infraspecific_name,
infrasubspecific_name, kingdom, order, phylum, section, series, species, strain, subclass,
subfamily, subform, subgenus, subkingdom, suborder, subphylum, subsection, subseries,
subspecies, subtribe, subvariety, superclass, superfamily, superorder, superphylum,
suprageneric_name, tribe, unranked, or variety.}

\item{fields}{(character) Fields to return in output data.frame (simply prunes columns off)}
}
\value{
A data.frame with fields selected by fields arg.
}
\description{
A quick and simple autocomplete service that returns up to 20 name usages by
doing prefix matching against the scientific name. Results are ordered by relevance.
}
\examples{
\dontrun{
name_suggest(q='Puma concolor')
name_suggest(q='Puma')
name_suggest(q='Puma', rank="genus")
name_suggest(q='Puma', rank="subspecies")
name_suggest(q='Puma', rank="species")
name_suggest(q='Puma', rank="infraspecific_name")

name_suggest(q='Puma', limit=2)
name_suggest(q='Puma', fields=c('key','canonicalName'))
name_suggest(q='Puma', fields=c('key','canonicalName','higherClassificationMap'))
}
}
\references{
\url{http://www.gbif.org/developer/summary}
}

