% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftheme.R
\name{f_theme}
\alias{f_theme}
\title{Apply a black or white 'RStudio' Theme and Zoom Level}
\usage{
f_theme(color = "black", zlevel = 0)
}
\arguments{
\item{color}{A character string. The theme color to apply. Must be either \code{"black"} (dark theme) or \code{"white"} (light theme). Default is \code{"black"}.}

\item{zlevel}{A numeric value. The zoom level to apply, ranging from \code{0} (default size) to \code{4} (maximum zoom). Default is \code{0}.}
}
\value{
None. The function is called for its side effects of changing the 'RStudio' theme or Zoomlevel.

This function does not return a value. It applies changes directly to the 'RStudio' IDE.
}
\description{
This comes in hand when teaching, the function allows users to apply a "black" or "white" 'RStudio' theme and adjust the zoom level in the 'RStudio' IDE. It includes error handling for invalid inputs.
}
\details{
The function performs the following actions:
\enumerate{
\item Applies the specified 'RStudio' theme:
\itemize{
  \item \code{"black"}: Applies the "Tomorrow Night 80s" dark theme.
  \item \code{"white"}: Applies the "Textmate (default)" light theme.
  }
\item Adjusts the zoom level in 'RStudio':
\itemize{
  \item \code{zlevel = 0}: Resets to default zoom level.
  \item \code{zlevel = 1}: Zooms in once.
  \item \code{zlevel = 2}: Zooms in twice.
  \item \code{zlevel = 3}: Zooms in three times.
  \item \code{zlevel = 4}: Zooms in four times.
  }
}
The function includes error handling to ensure valid inputs:
 \itemize{
\item \code{color} must be a character string and one of \code{"black"} or \code{"white"}.
\item \code{zlevel} must be a numeric value, an integer, and within the range of 0 to 4. If a non-integer is provided, it will be rounded to the nearest integer with a warning.
}
}
\examples{
# NOTE: This example will change your RStudio theme hence the dont run warning.
\dontrun{
# Apply a dark theme with with zoom level 2:
f_theme(color = "black", zlevel = 2)

# Apply a black theme with maximum zoom level:
f_theme(color = "black", zlevel = 4)

# Apply the default light theme default zoom level:
f_theme(color = "black", zlevel = 0)
}

}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
