/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.graphOperations.dominance;

import org.chocosolver.util.graphOperations.dominance.AbstractLengauerTarjanDominatorsFinder;
import org.chocosolver.util.objects.graphs.DirectedGraph;

public class AlphaDominatorsFinder
extends AbstractLengauerTarjanDominatorsFinder {
    private final int[] size;
    private final int[] child;

    public AlphaDominatorsFinder(int s, DirectedGraph g) {
        super(s, g);
        this.size = new int[this.n];
        this.child = new int[this.n];
    }

    @Override
    protected void initParams(boolean inverseGraph) {
        super.initParams(inverseGraph);
        for (int i = 0; i < this.n; ++i) {
            this.size[i] = 0;
            this.child[i] = this.root;
        }
    }

    @Override
    protected void link(int v, int w) {
        int s = w;
        while (this.semi[this.label[w]] < this.semi[this.label[this.child[s]]]) {
            if (this.size[s] + this.size[this.child[this.child[s]]] >= 2 * this.size[this.child[s]]) {
                this.ancestor[this.child[s]] = s;
                this.child[s] = this.child[this.child[s]];
                continue;
            }
            this.size[this.child[s]] = this.size[s];
            this.ancestor[s] = this.child[s];
            s = this.ancestor[s];
        }
        this.label[s] = this.label[w];
        this.size[v] = this.size[v] + this.size[w];
        if (this.size[v] < 2 * this.size[w]) {
            int k = s;
            s = this.child[v];
            this.child[v] = k;
        }
        while (s != this.root) {
            this.ancestor[s] = v;
            s = this.child[s];
        }
    }

    @Override
    protected int eval(int v) {
        if (this.ancestor[v] == -1) {
            return this.label[v];
        }
        this.compress(v);
        if (this.semi[this.label[this.ancestor[v]]] >= this.semi[this.label[v]]) {
            return this.label[v];
        }
        return this.label[this.ancestor[v]];
    }

    @Override
    protected void compress(int v) {
        int k = v;
        this.list.resetQuick();
        while (this.ancestor[this.ancestor[k]] != -1) {
            this.list.add(k);
            k = this.ancestor[k];
        }
        for (k = this.list.size() - 1; k >= 0; --k) {
            v = this.list.get(k);
            if (this.semi[this.label[this.ancestor[v]]] < this.semi[this.label[v]]) {
                this.label[v] = this.label[this.ancestor[v]];
            }
            this.ancestor[v] = this.ancestor[this.ancestor[v]];
        }
    }
}

