/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.sum;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropSumWithLong
extends Propagator<IntVar> {
    protected final int pos;
    protected final int l;
    protected final long b;
    protected final long[] I;
    protected long maxI;
    protected long sumLB;
    protected long sumUB;
    protected final Operator o;

    public PropSumWithLong(IntVar[] variables, int pos, Operator o, long b) {
        this(variables, pos, o, b, PropSumWithLong.computePriority(variables.length), false);
    }

    PropSumWithLong(IntVar[] variables, int pos, Operator o, long b, PropagatorPriority priority, boolean reactOnFineEvent) {
        super((Variable[])variables, (Priority)priority, reactOnFineEvent);
        this.pos = pos;
        this.o = o;
        this.b = b;
        this.l = variables.length;
        this.I = new long[this.l];
        this.maxI = 0L;
    }

    protected static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 1) {
            return PropagatorPriority.UNARY;
        }
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        switch (this.o) {
            case NQ: {
                return IntEventType.instantiation();
            }
            case LE: {
                return IntEventType.combine(IntEventType.INSTANTIATE, vIdx < this.pos ? IntEventType.INCLOW : IntEventType.DECUPP);
            }
            case GE: {
                return IntEventType.combine(IntEventType.INSTANTIATE, vIdx < this.pos ? IntEventType.DECUPP : IntEventType.INCLOW);
            }
        }
        return IntEventType.boundAndInst();
    }

    protected void prepare() {
        int ub;
        int lb;
        int i;
        this.sumUB = 0L;
        this.sumLB = 0L;
        this.maxI = 0L;
        for (i = 0; i < this.pos; ++i) {
            lb = ((IntVar[])this.vars)[i].getLB();
            ub = ((IntVar[])this.vars)[i].getUB();
            this.sumLB += (long)lb;
            this.sumUB += (long)ub;
            this.I[i] = ub - lb;
            if (this.maxI >= this.I[i]) continue;
            this.maxI = this.I[i];
        }
        while (i < this.l) {
            lb = -((IntVar[])this.vars)[i].getUB();
            ub = -((IntVar[])this.vars)[i].getLB();
            this.sumLB += (long)lb;
            this.sumUB += (long)ub;
            this.I[i] = ub - lb;
            if (this.maxI < this.I[i]) {
                this.maxI = this.I[i];
            }
            ++i;
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.filter();
    }

    protected void filter() throws ContradictionException {
        this.prepare();
        switch (this.o) {
            case LE: {
                this.filterOnLeq();
                break;
            }
            case GE: {
                this.filterOnGeq();
                break;
            }
            case NQ: {
                this.filterOnNeq();
                break;
            }
            default: {
                this.filterOnEq();
            }
        }
    }

    protected void filterOnEq() throws ContradictionException {
        boolean anychange;
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        do {
            anychange = false;
            if (this.model.getSolver().isLearnOff() && (F2 < 0L || E < 0L)) {
                this.fails();
            }
            if (this.maxI > F2 || this.maxI > E) {
                int nlb;
                int nub;
                long ub;
                long lb;
                int i;
                this.maxI = 0L;
                for (i = 0; i < this.pos; ++i) {
                    if (this.I[i] - F2 > 0L) {
                        lb = ((IntVar[])this.vars)[i].getLB();
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) {
                            nub = ((IntVar[])this.vars)[i].getUB();
                            E += (long)nub - ub;
                            this.I[i] = (long)nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0L) {
                        ub = ((IntVar[])this.vars)[i].getUB();
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) {
                            nlb = ((IntVar[])this.vars)[i].getLB();
                            F2 -= (long)nlb - lb;
                            this.I[i] = ub - (long)nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI >= this.I[i]) continue;
                    this.maxI = this.I[i];
                }
                while (i < this.l) {
                    if (this.I[i] - F2 > 0L) {
                        lb = -((IntVar[])this.vars)[i].getUB();
                        ub = lb + this.I[i];
                        if (((IntVar[])this.vars)[i].updateLowerBound(-F2 - lb, (ICause)this)) {
                            nub = -((IntVar[])this.vars)[i].getLB();
                            E += (long)nub - ub;
                            this.I[i] = (long)nub - lb;
                            anychange = true;
                        }
                    }
                    if (this.I[i] - E > 0L) {
                        ub = -((IntVar[])this.vars)[i].getLB();
                        lb = ub - this.I[i];
                        if (((IntVar[])this.vars)[i].updateUpperBound(-ub + E, (ICause)this)) {
                            nlb = -((IntVar[])this.vars)[i].getUB();
                            F2 -= (long)nlb - lb;
                            this.I[i] = ub - (long)nlb;
                            anychange = true;
                        }
                    }
                    if (this.maxI < this.I[i]) {
                        this.maxI = this.I[i];
                    }
                    ++i;
                }
            }
            if (F2 > 0L || E > 0L) continue;
            this.setPassive();
            return;
        } while (anychange);
    }

    protected void filterOnLeq() throws ContradictionException {
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && F2 < 0L) {
            this.fails();
        }
        if (this.maxI > F2) {
            int nub;
            long ub;
            long lb;
            int i;
            this.maxI = 0L;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - F2 > 0L) {
                    lb = ((IntVar[])this.vars)[i].getLB();
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(F2 + lb, (ICause)this)) {
                        nub = ((IntVar[])this.vars)[i].getUB();
                        E += (long)nub - ub;
                        this.I[i] = (long)nub - lb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - F2 > 0L) {
                    lb = -((IntVar[])this.vars)[i].getUB();
                    ub = lb + this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(-F2 - lb, (ICause)this)) {
                        nub = -((IntVar[])this.vars)[i].getLB();
                        E += (long)nub - ub;
                        this.I[i] = (long)nub - lb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (E <= 0L) {
            this.setPassive();
        }
    }

    protected void filterOnGeq() throws ContradictionException {
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        if (this.model.getSolver().isLearnOff() && E < 0L) {
            this.fails();
        }
        if (this.maxI > E) {
            int nlb;
            long lb;
            long ub;
            int i;
            this.maxI = 0L;
            for (i = 0; i < this.pos; ++i) {
                if (this.I[i] - E > 0L) {
                    ub = ((IntVar[])this.vars)[i].getUB();
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateLowerBound(ub - E, (ICause)this)) {
                        nlb = ((IntVar[])this.vars)[i].getLB();
                        F2 -= (long)nlb - lb;
                        this.I[i] = ub - (long)nlb;
                    }
                }
                if (this.maxI >= this.I[i]) continue;
                this.maxI = this.I[i];
            }
            while (i < this.l) {
                if (this.I[i] - E > 0L) {
                    ub = -((IntVar[])this.vars)[i].getLB();
                    lb = ub - this.I[i];
                    if (((IntVar[])this.vars)[i].updateUpperBound(-ub + E, (ICause)this)) {
                        nlb = -((IntVar[])this.vars)[i].getUB();
                        F2 -= (long)nlb - lb;
                        this.I[i] = ub - (long)nlb;
                    }
                }
                if (this.maxI < this.I[i]) {
                    this.maxI = this.I[i];
                }
                ++i;
            }
        }
        if (F2 <= 0L) {
            this.setPassive();
        }
    }

    protected void filterOnNeq() throws ContradictionException {
        long F2 = this.b - this.sumLB;
        long E = this.sumUB - this.b;
        if (F2 < 0L || E < 0L) {
            this.setPassive();
            return;
        }
        int w = -1;
        int sum = 0;
        for (int i = 0; i < this.l; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) {
                sum += i < this.pos ? ((IntVar[])this.vars)[i].getValue() : -((IntVar[])this.vars)[i].getValue();
                continue;
            }
            if (w == -1) {
                w = i;
                continue;
            }
            return;
        }
        if (w == -1) {
            if ((long)sum == this.b) {
                this.fails();
            }
        } else {
            ((IntVar[])this.vars)[w].removeValue(w < this.pos ? this.b - (long)sum : (long)sum - this.b, (ICause)this);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        long sumUB = 0L;
        long sumLB = 0L;
        for (i = 0; i < this.pos; ++i) {
            sumLB += (long)((IntVar[])this.vars)[i].getLB();
            sumUB += (long)((IntVar[])this.vars)[i].getUB();
        }
        while (i < this.l) {
            sumLB -= (long)((IntVar[])this.vars)[i].getUB();
            sumUB -= (long)((IntVar[])this.vars)[i].getLB();
            ++i;
        }
        return this.check(sumLB, sumUB);
    }

    public ESat check(long sumLB, long sumUB) {
        switch (this.o) {
            case NQ: {
                if (sumUB < this.b || sumLB > this.b) {
                    return ESat.TRUE;
                }
                if (sumUB == this.b && sumLB == this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            case LE: {
                if (sumUB <= this.b) {
                    return ESat.TRUE;
                }
                if (sumLB > this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
            case GE: {
                if (sumLB >= this.b) {
                    return ESat.TRUE;
                }
                if (sumUB < this.b) {
                    return ESat.FALSE;
                }
                return ESat.UNDEFINED;
            }
        }
        if (sumLB == this.b && sumUB == this.b) {
            return ESat.TRUE;
        }
        if (sumUB < this.b || sumLB > this.b) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder linComb = new StringBuilder(20);
        linComb.append(this.pos == 0 ? "-" : "").append(((IntVar[])this.vars)[0].getName());
        for (i = 1; i < this.pos; ++i) {
            linComb.append(" + ").append(((IntVar[])this.vars)[i].getName());
        }
        while (i < this.l) {
            linComb.append(" - ").append(((IntVar[])this.vars)[i].getName());
            ++i;
        }
        linComb.append(" ").append((Object)this.o).append(" ");
        linComb.append(this.b);
        return linComb.toString();
    }

    public static long nb(Operator co) {
        switch (co) {
            case LE: {
                return 1L;
            }
            case GE: {
                return -1L;
            }
        }
        return 0L;
    }

    public static Operator nop(Operator co) {
        switch (co) {
            case LE: {
                return Operator.GE;
            }
            case GE: {
                return Operator.LE;
            }
        }
        return Operator.getOpposite(co);
    }

    protected PropSumWithLong opposite() {
        return new PropSumWithLong((IntVar[])this.vars, this.pos, PropSumWithLong.nop(this.o), this.b + PropSumWithLong.nb(this.o));
    }
}

