% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_facts.R
\name{get_facts_file_example}
\alias{get_facts_file_example}
\title{Locate an example FACTS file}
\usage{
get_facts_file_example(facts_file)
}
\arguments{
\item{facts_file}{Character, name of a FACTS file.
Usually has a \verb{*.facts} file extension.
Does not include the directory name.
Possible choices:
\itemize{
\item "aipf_contin.facts" - Enrichment continuous.
\item "aipf_dichot.facts" - Enrichment dichotomous.
\item "aipf_tte.facts" - Enrichment time to event.
\item "broken.facts" - A broken FACTS file.
\item "contin.facts" - Core continuous.
\item "crm.facts" - N-CRM design.
\item "dichot.facts" - Core dichotomous.
\item "multep.facts" - Multiple endpoints.
\item "staged.facts" - Staged design.
\item "tte.facts" - Time to event.
\item "unsupported.facts" - FACTS file with an unsupported engine type.
}}
}
\value{
Character, the path to a FACTS file included with \code{rfacts}.
}
\description{
Get the path to an example FACTS file inside rfacts itself.
}
\details{
The \code{rfacts} package comes with some example FACTS files.
Use the \code{get_facts_file_example()} function to get the full path
to an example FACTS file. Use this file to try out \code{\link[=run_flfll]{run_flfll()}},
\code{\link[=run_engine_contin]{run_engine_contin()}}, etc.
}
\examples{
# Only run if system dependencies are configured:
if (file.exists(Sys.getenv("RFACTS_PATHS"))) {
facts_file <- get_facts_file_example("contin.facts")
facts_file
out <- run_facts(
  facts_file,
  n_sims = 1,
  verbose = FALSE
)
read_patients(out)
}
}
\seealso{
\code{\link[=run_facts]{run_facts()}}, \code{\link[=run_flfll]{run_flfll()}}, \code{\link[=run_engine]{run_engine()}}, \code{\link[=run_engine_contin]{run_engine_contin()}}
}
