% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.collinear.R
\name{multi.collinear}
\alias{multi.collinear}
\title{Multi-collinearity test}
\usage{
multi.collinear(x, p = 1e-07)
}
\arguments{
\item{x}{data.frame or matrix object}

\item{p}{multi-collinearity threshold}
}
\value{
test statistic message

names character vector of multi-collinearity variables
}
\description{
Test for multi-collinearity in data using qr-matrix decomposition
}
\note{
The multi-collinearity threshold needs to be adjusted based on number of parameters. For small number(s) of variables (<20) use ~1e-07 and for larger ~0.05
}
\examples{
 
test <- data.frame(v1=seq(0.1, 5, length=100), v2=seq(0.1, 5, length=100), 
                   v3=dnorm(runif(100)), v4=dnorm(runif(100))) 
  ( cl <- multi.collinear(test) )

# PCA biplot of variables
pca.test <- prcomp(test[,1:ncol(test)], scale=TRUE)
  biplot(pca.test, arrow.len=0.1, xlabs=rep(".", length(pca.test$x[,1])))        

 # Remove identified variable(s)
 test <- test[,-which(names(test)==cl)]

}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) The New S Language. Wadsworth & Brooks/Cole.

Dongarra, J. J., Bunch, J. R., Moler, C. B. and Stewart, G. W. (1978) LINPACK Users Guide. Philadelphia: SIAM Publications.
}
\author{
Jeffrey S. Evans  <jeffrey_evans<at>tnc.org>
}
