% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_categories_and_events.R
\name{get_categories_and_events}
\alias{get_categories_and_events}
\title{Get All Categories and Events for a List of Product Ids}
\usage{
get_categories_and_events(rev_product_ids, rev_session_id, rev_username)
}
\arguments{
\item{rev_product_ids}{A vector of Revenera product id's for which
you want active user data.}

\item{rev_session_id}{Session ID established by the connection to
Revenera API. This can be obtained with revenera_auth().}

\item{rev_username}{Revenera username.}
}
\value{
Data frame with categories, events and event type by product id.
}
\description{
Returns all of the unique categories and events (basic and advanced)
for each product id.
}
\details{
It is not recommended that your username be stored directly in your
code. There are various methods and packages available that are more 
secure; this package does not require you to use any one in particular.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
product_ids_list <- c("123", "456", "789")
session_id <- revenera_auth(rev_user, rev_pwd)  
category_event <- get_categories_and_events(product_ids_list, session_id, rev_user)
}
}
