% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diagnostics.R
\name{summary.evpost}
\alias{summary.evpost}
\title{Summarizing an evpost object}
\usage{
\method{summary}{evpost}(object, add_pu = FALSE, ...)
}
\arguments{
\item{object}{An object of class "evpost", a result of a call to
\code{\link{rpost}} or \code{\link{rpost_rcpp}}.}

\item{add_pu}{Includes in the summary of the simulated values the threshold
exceedance probability \eqn{p}. Only relevant when \code{model == "bingp"}
was used in the call to \code{rpost} or \code{rpost_rcpp}.}

\item{...}{Additional arguments passed on to \code{print}.}
}
\value{
Prints
\itemize{
  \item {information about the ratio-of-uniforms bounding box, i.e.
    \code{object$box}}
  \item {an estimate of the probability of acceptance, i.e.
    \code{object$pa}}
  \item {a summary of the simulated values, via
    \code{summary(object$sim_vals)}}
}
}
\description{
\code{summary} method for class "evpost"
}
\examples{
# GP posterior
data(gom)
u <- stats::quantile(gom, probs = 0.65)
fp <- set_prior(prior = "flat", model = "gp", min_xi = -1)
gpg <- rpost_rcpp(n = 1000, model = "gp", prior = fp, thresh = u,
                  data = gom)
summary(gpg)
}
\seealso{
\code{\link[rust]{ru}} or \code{\link[rust]{ru_rcpp}} for
  descriptions of \code{object$sim_vals} and \code{object$box}.

\code{\link{plot.evpost}} for a diagnostic plot.
}
