% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/reval.r
\name{evalmany}
\alias{evalmany}
\title{Repeated evaluations}
\usage{
evalmany(fun, ..., method = c("ofat", "permute", "set"), sample = 0L,
  default.args = list(), collate = TRUE, collate.id = c("single",
  "multi"), collate.prepend = "", collate.fun = identity, clusters = 1L,
  packages = NULL)
}
\arguments{
\item{fun}{The function to be evaluated.}

\item{...}{Arguments to be varied when evaluating \code{fun}, where each
argument in '\code{...}' is a (named) vector or list of values. Lists of
multi-value objects (e.g. data.frames) should be named explicitly and may
otherwise produce unexpected or incorrect names.}

\item{method}{The sensitivity analysis method to be used. Can be either
one-factor-at-a-time ("ofat") evaluation, evaluation of parameter sets
("set"), or (sampled) permutations of parameter sets ("permute"). When
\code{method = "ofat"}, the first element of each argument in '\code{...}'
is assumed to be the "default" value of that argument.}

\item{sample}{If \code{method = "permute"}, the number of parameter
permutations to evaluate (sampling without replacement).
If \code{sample < 1} (the default) then all possible permutations are
evaluated.}

\item{default.args}{The default values of arguments passed to \code{fun}.}

\item{collate}{Whether to collate the results or not. If TRUE, output
elements will be coerced into data.frames using \code{as.data.frame}.
Otherwise, the raw outputs will be returned as a named list.}

\item{collate.id}{If \code{collate = TRUE}, the method used to
store the evaluation identifiers. If \code{collate.id = "single"}, a
single column named 'id' is used. If \code{collate.id = "multi"},
one column is created for each argument in '\code{...}', e.g.
'arg1', 'arg2', etc.}

\item{collate.prepend}{A character string prepended to the identifier
column. If \code{collate.id = "single"}, the identifier column will be
named \code{<collate.prepend>id}. If \code{collate.id = "multi"},
identifier columns will be named as \code{<collate.prepend><arg>} where
\code{arg} is an element of \code{...}.}

\item{collate.fun}{If \code{collate = TRUE}, an optional function
for reshaping the output of each evaluation prior to coercing and
collating the outputs.}

\item{clusters}{Number of clusters to use for parallel processing. Default
is 1 (serial computation).}

\item{packages}{For parallel processing. Character vector of packages that
  'fun' depends on.}
}
\value{
If \code{collate = TRUE}, a data.frame. Otherwise, a named list.
}
\description{
Evaluate a function repeatedly across argument sets or permutations.
}
\examples{
myfun = function(n, mean=0, sd = 1){
  x = rnorm(n, mean, sd)
  data.frame(sample.mean = mean(x), sample.sd = sd(x))
}
evalmany(myfun, mean = c(5, 9), sd = c(2, 3), default.args = list(n = 1e6))
evalmany(myfun, mean = seq(20), sd = seq(1, 4, by = 0.1),
  default.args = list(n = 1e6), method = "permute", sample = 10,
  collate.id = "multi", collate.prepend = "arg.")

# vector recycling
evalmany(myfun, mean = c(0, 3, 5), sd = c(1, 10),
  default.args = list(n = 1e6), method = "set", collate.id = "multi")

# Parallel processing
evalmany(myfun, mean = seq(0, 50, by = 10), sd = seq(1, 10, by = 1.5),
  default.args = list(n = 1e5), method = "permute", collate.id = "multi",
  clusters = 2)

\dontrun{
# Complex objects
formulas = list(y ~ 1, y ~ x, y ~ x + z)
datasets = list(
  A = data.frame(x = seq(0, 99), y = seq(0, 99) + rnorm(100)),
  B = data.frame(x = seq(0, 99), y = seq(0, 99) + rnorm(100, mean = 5)),
  C = data.frame(x = seq(0, 99), y = seq(0, 99) + rlnorm(100, meanlog = 1),
    z = seq(0, 99) - rlnorm(100, meanlog = -1))
)
# raw output
evalmany(lm, formula = formulas, data = datasets, method = "set",
  collate = FALSE)
# data extraction and error handling
evalmany(lm, formula = formulas, data = datasets, method = "permute",
  collate.id = "multi", collate.fun = function(x)
    data.frame(param = names(x$coefficients), value = x$coefficients,
    row.names=NULL))
}
}

