% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileCombinations.R
\name{profileCombinations}
\alias{profileCombinations}
\title{Compute drug combination response signatures}
\usage{
profileCombinations(responseProfiles)
}
\arguments{
\item{responseProfiles}{A matrix of response profiles for drugs (rows are genes, columns are drugs)}
}
\value{
A matrix with genes in the rows and profiles combination in the columns. The values represent the expected transcriptional response of the cells (used as input of retriever) to a drug combination.
}
\description{
Returns the average of every possible two response profile non-redundant combination from the input matrix
}
\examples{
# Loading robust profiles across different breast cancer cell lines generated by retriever.
# BRCA <- retriever(cellLines = c('MDAMB231', 'MCF7', 'SKBR3', 'HS578T', 'BT20'))

  BRCA <- read.csv(system.file("BRCA.csv",package="retriever"), row.names = 1)
  dim(BRCA)
  # [1] 1001  125

# Computing response profiles combinations
  combinationsBRCA <- profileCombinations(BRCA)
  dim(combinationsBRCA)
  # [1] 1001 7750
}
