% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RetinalReconstructedOutline.R
\name{projection.RetinalReconstructedOutline}
\alias{projection.RetinalReconstructedOutline}
\title{Plot projection of reconstructed dataset}
\usage{
\method{projection}{RetinalReconstructedOutline}(r,
  transform = identity.transform, projection = azimuthal.equalarea,
  axisdir = cbind(phi = 90, lambda = 0), proj.centre = cbind(phi = 0,
  lambda = 0), lambdalim = c(-180, 180), datapoints = TRUE,
  datapoint.means = TRUE, datapoint.contours = FALSE,
  grouped = FALSE, grouped.contours = FALSE, landmarks = TRUE,
  mesh = FALSE, grid = TRUE, image = TRUE, ids = r$getIDs(), ...)
}
\arguments{
\item{r}{\code{\link{RetinalReconstructedOutline}} object}

\item{transform}{Transform function to apply to spherical coordinates
before rotation}

\item{projection}{Projection in which to display object,
e.g. \code{\link{azimuthal.equalarea}} or \code{\link{sinusoidal}}}

\item{axisdir}{Direction of axis (North pole) of sphere in external space}

\item{proj.centre}{Location of centre of projection as matrix with
column names \code{phi} (elevation) and \code{lambda} (longitude).}

\item{lambdalim}{Limits of longitude (in degrees) to display}

\item{datapoints}{If \code{TRUE}, display data points}

\item{datapoint.means}{If \code{TRUE}, display Karcher mean of data points.}

\item{datapoint.contours}{If \code{TRUE}, display contours around
the data points generated using Kernel Density Estimation.}

\item{grouped}{If \code{TRUE}, display grouped data.}

\item{grouped.contours}{If \code{TRUE}, display contours around
the grouped data generated using Kernel Regression.}

\item{landmarks}{If \code{TRUE}, display landmarks.}

\item{mesh}{If \code{TRUE}, display the triangular mesh used in reconstruction}

\item{grid}{If \code{TRUE}, show grid lines}

\item{image}{If \code{TRUE}, show the reconstructed image}

\item{ids}{IDs of groups of data within a dataset, returned using
\code{getIDs}.}

\item{...}{Graphical parameters to pass to plotting functions}
}
\description{
Plot projection of reconstructed dataset
}
