% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conda.R
\name{conda_run2}
\alias{conda_run2}
\title{Run a command in a conda environment}
\usage{
conda_run2(
  cmd,
  args = c(),
  conda = "auto",
  envname = NULL,
  cmd_line = paste(shQuote(cmd), paste(args, collapse = " ")),
  intern = FALSE,
  echo = !intern
)
}
\arguments{
\item{cmd}{The system command to be invoked, as a character string.}

\item{args}{A character vector of arguments to the command. The arguments should
be quoted e.g. by \code{shQuote()} in case they contain space or other special
characters (a double quote or backslash on Windows, shell-specific special
characters on Unix).}

\item{conda}{The path to a \code{conda} executable. Use \code{"auto"} to allow
\code{reticulate} to automatically find an appropriate \code{conda} binary.
See \strong{Finding Conda} and \code{\link[=conda_binary]{conda_binary()}} for more details.}

\item{envname}{The name of, or path to, a conda environment.}

\item{cmd_line}{The command line to be executed, as a character string. This
is automatically generated from \code{cmd} and \code{args}, but can be provided
directly if needed (if provided, it overrides \code{cmd} and \code{args}).}

\item{intern}{A logical (not \code{NA}) which indicates whether to capture the
output of the command as an R character vector. If \code{FALSE} (the default), the
return value is the error code (\code{0} for success).}

\item{echo}{A logical (not \code{NA}) which indicates whether to echo the command to
the console before running it.}
}
\value{
\code{conda_run2()} runs a command in the desired conda environment. If
\code{intern = TRUE} the output is returned as a character vector; if \code{intern = FALSE} (the
deafult), then the return value is the error code (0 for success). See
\code{\link[=shell]{shell()}} (on windows) or \code{\link[=system2]{system2()}} on macOS or Linux for more details.
}
\description{
This function runs a command in a chosen conda environment.
}
\details{
Note that, whilst the syntax is similar to \code{\link[=system2]{system2()}}, the function
dynamically generates a shell script with commands to activate the chosen
conda environent. This avoids issues with quoting, as discussed in this
\href{https://github.com/conda/conda/issues/10972}{GitHub issue}.
}
\seealso{
\code{\link{conda-tools}}
}
