% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualenv.R
\name{virtualenv-tools}
\alias{virtualenv-tools}
\alias{virtualenv_list}
\alias{virtualenv_create}
\alias{virtualenv_install}
\alias{virtualenv_remove}
\alias{virtualenv_root}
\alias{virtualenv_python}
\title{Interface to Python Virtual Environments}
\usage{
virtualenv_list()

virtualenv_create(envname, python = NULL)

virtualenv_install(envname, packages, ignore_installed = TRUE)

virtualenv_remove(envname, packages = NULL, confirm = interactive())

virtualenv_root()

virtualenv_python(envname)
}
\arguments{
\item{envname}{The name of, or path to, a Python virtual environment. If
this name contains any slashes, the name will be interpreted as a path;
if the name does not contain slashes, it will be treated as a virtual
environment within \code{virtualenv_root()}.}

\item{python}{The path to a Python interpreter, to be used with the created
virtual environment. When \code{NULL}, the Python interpreter associated with
the current session will be used.}

\item{packages}{A character vector with package names to install or remove.}

\item{ignore_installed}{Boolean; ignore previously-installed versions of the
requested packages? (This should normally be \code{TRUE}, so that pre-installed
packages available in the site libraries are ignored and hence packages
are installed into the virtual environment.)}

\item{confirm}{Boolean; confirm before removing packages or virtual
environments?}
}
\description{
R functions for managing Python \href{https://virtualenv.pypa.io/en/stable/}{virtual environments}.
}
\details{
Virtual environments are by default located at \code{~/.virtualenvs} (accessed
with the \code{virtualenv_root} function). You can change the default location by
defining defining the \code{WORKON_HOME} environment variable.

Virtual environment functions are not supported on Windows (the use of
\link[=conda-tools]{conda environments} is recommended on Windows).
}
