% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reql.R
\name{r}
\alias{r}
\title{ReQL root}
\usage{
r(db, table)
}
\arguments{
\item{db}{DB name; this is optional, and is just a syntax sugar for \code{r()$db(db)}.}

\item{table}{Table name; this is optional, requires db to be given, and is just a syntax sugar for \code{r()$db(db)$table(table)}}
}
\value{
ReQL root; use \code{$} (or \code{[[]]}) to chain query terms (like \code{r()$db("test")$table("test")}).
In general, anonymous attributes are passed as attributes while named as term options.
In context of term arguments, named lists are treated as JSON objects (following \code{rjson} package heuristics), unnamed lists and simple vectors as JSON arrays; classes and attributes are ignored.
Term options should be called in the snake case form (for instance \code{return_changes} not \code{returnChanges}), as documented for the original Python driver.
To finalise, use \code{$run} or \code{$runAsync}.
For a comprehensive description of all terms, see RethinkDB API reference; here we give an overview of some:
\item{run(connection,...)}{Evaluate the query; the function will block until first response from RethinkDB to this query will be received.
May return cursor, an object representing a stream of data on which \code{\link{cursorNext}} and \code{\link{cursorToList}} can be used to extract actual information.
\code{...} may be used to specify run options, like \code{profile}, \code{durability} or \code{read_mode}.}
\item{runAsync(connection,callback,...)}{Evaluate the query; for each datum received \code{x}, run \code{callback(x)}.
Callback should return \code{TRUE} to be re-evaluated on proceeding data; any other response will cause the query to be dropped immediately.
This function returns immediately; to ask R to start evaluating async queries, run \code{\link{drainConnection}}.
Note that callbacks can be also called while \code{$run()} blocks waiting for other query to execute.}
\item{bracket(...)}{Implementation of the JavaScript \code{(...)} and Python \code{[...]} operation.}
\item{funcall(function,atts)}{Implementation of the JavaScript \code{.do()}; note that the order of arguments is different.}
}
\description{
Creates ReQL root for building a query.
}
\note{
ReQL is implemented as an environment, thus is mutable unlike most R objects.
To this end, you can use variables for chaining like this \code{r()->query;} \code{query$db("a");} \code{query$table("b")}; but consequently you can't use variables to make a re-usable stub, i.e., this is invalid: \code{r()->query;} \code{query$db("a")$table("aa")$run(...)} \code{query$db("b")$table("bb")$run(...);}.

If you get "trying to apply non-function" error, you likely have misspelled term name or trying to use a non-existent one.

To view raw AST (at any depth), use \code{$query}.
}
\author{
Miron B. Kursa
}

