/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.set;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.ISetDelta;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.view.SetView;
import org.chocosolver.solver.variables.view.delta.SetViewOnSetsDeltaMonitor;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetDifference;
import org.chocosolver.util.procedure.IntProcedure;

public class SetDifferenceView
extends SetView<SetVar> {
    protected SetDifference lb;
    protected SetDifference ub;
    protected SetVar x;
    protected SetVar y;

    public SetDifferenceView(String name, SetVar x, SetVar y) {
        super(name, (Variable[])new SetVar[]{x, y});
        this.x = x;
        this.y = y;
        this.lb = new SetDifference(this.getModel(), x.getLB(), y.getLB());
        this.ub = new SetDifference(this.getModel(), x.getUB(), y.getLB());
    }

    @Override
    public ISet getLB() {
        return this.lb;
    }

    @Override
    public ISet getUB() {
        return this.ub;
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        return false;
    }

    @Override
    public boolean isInstantiated() {
        return this.getLB().size() == this.getUB().size();
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        this.notifyPropagators(event, this);
    }

    @Override
    protected boolean doRemoveSetElement(int element) throws ContradictionException {
        if (this.x.getUB().contains(element) && !this.y.getUB().contains(element)) {
            return this.x.remove(element, this);
        }
        if (this.x.getLB().contains(element) && this.y.getUB().contains(element)) {
            return this.y.force(element, this);
        }
        return false;
    }

    @Override
    protected boolean doForceSetElement(int element) throws ContradictionException {
        return this.x.force(element, this) | this.y.remove(element, this);
    }

    @Override
    public ISetDelta getDelta() {
        throw new UnsupportedOperationException("SetDifferenceView does not support getDelta()");
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        return new SetViewOnSetsDeltaMonitor(new ISetDeltaMonitor[]{this.x.monitorDelta(propagator), this.y.monitorDelta(propagator)}){

            @Override
            public void forEach(IntProcedure proc, SetEventType evt) throws ContradictionException {
                block5: {
                    int v;
                    block4: {
                        int v2;
                        this.fillValues();
                        if (evt != SetEventType.ADD_TO_KER) break block4;
                        ISetIterator iSetIterator = this.addedValues[0].iterator();
                        while (iSetIterator.hasNext()) {
                            v2 = (Integer)iSetIterator.next();
                            if (!SetDifferenceView.this.lb.contains(v2)) continue;
                            proc.execute(v2);
                        }
                        iSetIterator = this.removedValues[1].iterator();
                        while (iSetIterator.hasNext()) {
                            v2 = (Integer)iSetIterator.next();
                            if (!SetDifferenceView.this.lb.contains(v2)) continue;
                            proc.execute(v2);
                        }
                        break block5;
                    }
                    if (evt != SetEventType.REMOVE_FROM_ENVELOPE) break block5;
                    ISetIterator iSetIterator = this.removedValues[0].iterator();
                    while (iSetIterator.hasNext()) {
                        v = (Integer)iSetIterator.next();
                        if (SetDifferenceView.this.y.getLB().contains(v) || this.removedValues[1].contains(v)) continue;
                        proc.execute(v);
                    }
                    iSetIterator = this.addedValues[1].iterator();
                    while (iSetIterator.hasNext()) {
                        v = (Integer)iSetIterator.next();
                        if (!SetDifferenceView.this.x.getUB().contains(v) || this.addedValues[0].contains(v)) continue;
                        proc.execute(v);
                    }
                }
            }
        };
    }
}

