/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.delta;

import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.search.loop.TimeStampedObject;
import org.chocosolver.solver.variables.delta.IIntervalDelta;
import org.chocosolver.util.tools.ArrayUtils;

public final class IntervalDelta
extends TimeStampedObject
implements IIntervalDelta {
    private static final int SIZE = 32;
    private int[] from = new int[32];
    private int[] to = new int[32];
    private ICause[] causes = new ICause[32];
    private int last;

    public IntervalDelta(IEnvironment environment) {
        super(environment);
    }

    private void ensureCapacity() {
        if (this.last >= this.from.length) {
            int nsize = ArrayUtils.newBoundedSize(this.last, this.from.length * 2);
            this.from = Arrays.copyOf(this.from, nsize);
            this.to = Arrays.copyOf(this.to, nsize);
            this.causes = Arrays.copyOf(this.causes, nsize);
        }
    }

    @Override
    public void lazyClear() {
        if (this.needReset()) {
            this.last = 0;
            this.resetStamp();
        }
    }

    @Override
    public void add(int lb, int ub, ICause cause) {
        this.lazyClear();
        this.ensureCapacity();
        this.causes[this.last] = cause;
        this.from[this.last] = lb;
        this.to[this.last++] = ub;
    }

    @Override
    public int getLB(int idx) {
        return this.from[idx];
    }

    @Override
    public int getUB(int idx) {
        return this.to[idx];
    }

    @Override
    public ICause getCause(int idx) {
        return this.causes[idx];
    }

    @Override
    public int size() {
        return this.last;
    }
}

