/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.channeling.edges;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropNeighBoolsChannel2
extends Propagator<BoolVar> {
    private final int n;
    private final BoolVar[][] matrix;
    private final GraphVar g;

    public PropNeighBoolsChannel2(BoolVar[][] adjacencyMatrix, GraphVar gV) {
        super((Variable[])ArrayUtils.flatten(adjacencyMatrix), (Priority)PropagatorPriority.LINEAR, true);
        this.matrix = adjacencyMatrix;
        this.n = adjacencyMatrix.length;
        assert (this.n == adjacencyMatrix[0].length);
        this.g = gV;
        assert (this.n == this.g.getNbMaxNodes());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.matrix[i][j].getLB() == 1) {
                    this.g.enforceEdge(i, j, this);
                    continue;
                }
                if (this.matrix[i][j].getUB() != 0) continue;
                this.g.removeEdge(i, j, this);
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        int i = idxVarInProp / this.n;
        int j = idxVarInProp % this.n;
        if (this.matrix[i][j].getLB() == 1) {
            this.g.enforceEdge(i, j, this);
        } else {
            this.g.removeEdge(i, j, this);
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.matrix[i][j].getLB() == 1 && !this.g.getPotentialSuccessorsOf(i).contains(j)) {
                    return ESat.FALSE;
                }
                if (this.matrix[i][j].getUB() != 0 || !this.g.getMandatorySuccessorsOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

