% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terra_utils.R
\name{nb_cell_to_area}
\alias{nb_cell_to_area}
\title{Compute the area corresponding to a given number of cells.}
\usage{
nb_cell_to_area(raster_layer, nb_cells, unit = "ha")
}
\arguments{
\item{raster_layer}{\code{\link[terra:rast]{terra::rast()}} Raster object.}

\item{nb_cells}{\code{numeric} Number of raster cells.}

\item{unit}{\code{unit} object or a \code{character} that can be coerced to a unit
(see \code{unit} package). Must be an area unit.}
}
\value{
\code{numeric} The area corresponding to \code{nb_cells} in the desired unit.
}
\description{
Compute the area corresponding to a given number of cells.
}
\details{
The input raster must have a projected coordinate system. The distortion is
not corrected. It could be using the \code{cellSize} function of the \code{terra}
package, but this function is currently pretty slow for large rasters. If
your problem is at regional scale, the distortion should be negligible.
However, at larger scales, the best is to use an equal-area projected
coordinate system.
}
\examples{
\donttest{
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)
nb_cell_to_area(habitat_data, 20, unit = "ha")
}

}
