/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferentprec;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import java.util.stream.IntStream;

public class IntUnionFind {
    private final int[] values;
    private final TIntIntHashMap sets;
    private final int[] id;
    private final int[] sizes;
    private final int[] mins;
    private final int[] maxs;
    private final int n;

    public IntUnionFind(int l, int u) {
        this(IntStream.range(l, u + 1).toArray());
    }

    public IntUnionFind(int[] values) {
        this.values = values;
        Arrays.sort(this.values);
        this.n = values.length;
        this.sets = new TIntIntHashMap(this.n, 0.5f, -1, -1);
        this.mins = new int[this.n];
        this.maxs = new int[this.n];
        this.sizes = new int[this.n];
        this.id = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sets.put(this.values[i], i);
            this.mins[i] = this.values[i];
            this.maxs[i] = this.values[i];
            this.id[i] = i;
            this.sizes[i] = 1;
        }
    }

    public void init() {
        this.sets.clear();
        for (int i = 0; i < this.n; ++i) {
            this.sets.put(this.values[i], i);
            this.mins[i] = this.values[i];
            this.maxs[i] = this.values[i];
            this.sizes[i] = 1;
            this.id[i] = i;
            this.sizes[i] = 1;
        }
    }

    public int find(int a2) {
        return this.root(a2);
    }

    public int getMin(int idxSet) {
        return this.mins[idxSet];
    }

    public int getMax(int idxSet) {
        return this.maxs[idxSet];
    }

    private int root(int a2) {
        int i = this.sets.get(a2);
        if (i >= 0) {
            while (this.id[i] != i) {
                this.id[i] = this.id[this.id[i]];
                i = this.id[i];
            }
        }
        return i;
    }

    public void union(int a2, int b) {
        int idx1 = this.root(a2);
        int idx2 = this.root(b);
        int min = Math.min(this.mins[idx1], this.mins[idx2]);
        int max = Math.max(this.maxs[idx1], this.maxs[idx2]);
        if (this.sizes[idx1] < this.sizes[idx2]) {
            this.mins[idx2] = min;
            this.maxs[idx2] = max;
            int n = idx2;
            this.sizes[n] = this.sizes[n] + this.sizes[idx1];
            this.id[idx1] = idx2;
        } else {
            this.mins[idx1] = min;
            this.maxs[idx1] = max;
            int n = idx1;
            this.sizes[n] = this.sizes[n] + this.sizes[idx2];
            this.id[idx2] = idx1;
        }
    }

    public String toString() {
        return this.sets.toString() + "\nmins : " + Arrays.toString(this.mins) + "\nmaxs : " + Arrays.toString(this.maxs) + "\nid : " + Arrays.toString(this.id);
    }
}

