/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.tree;

import org.chocosolver.solver.constraints.graph.tree.PropArborescence;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropReachability
extends PropArborescence {
    public PropReachability(DirectedGraphVar graph, int root) {
        super(graph, root);
    }

    public PropReachability(DirectedGraphVar graph, int root, boolean simple) {
        super(graph, root, simple);
    }

    @Override
    protected void remBackArcs() throws ContradictionException {
    }

    @Override
    public ESat isEntailed() {
        if (!this.g.getPotentialNodes().contains(this.root)) {
            return ESat.FALSE;
        }
        boolean[] visited = new boolean[this.g.getNbMaxNodes()];
        int[] parent = new int[this.g.getNbMaxNodes()];
        visited[this.root] = true;
        parent[this.root] = this.root;
        int[] stack = new int[this.g.getNbMaxNodes()];
        int last = 0;
        stack[last] = this.root;
        while (last >= 0) {
            int current = stack[last--];
            ISetIterator iSetIterator = this.g.getPotentialSuccessorsOf(current).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (visited[j]) continue;
                visited[j] = true;
                parent[j] = current;
                stack[++last] = j;
            }
        }
        ISetIterator iSetIterator = this.g.getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (visited[i]) continue;
            return ESat.FALSE;
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

